/*
 * Decompiled with CFR 0.152.
 */
package dev.dokko.autoconfig.api.config;

import dev.dokko.autoconfig.AutoConfigAPI;
import dev.dokko.autoconfig.api.config.Config;
import dev.dokko.autoconfig.api.config.annot.BooleanSetting;
import dev.dokko.autoconfig.api.config.annot.Setting;
import dev.dokko.autoconfig.api.setting.ItemList;
import dev.dokko.autoconfig.api.ui.GeneratedConfigScreen;
import dev.dokko.autoconfig.api.ui.element.BooleanButton;
import dev.dokko.autoconfig.api.ui.element.EnumCyclerButton;
import dev.dokko.autoconfig.api.ui.element.ItemListEditorButton;
import dev.dokko.autoconfig.api.ui.element.UIElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_437;

public class ConfigSupplier<T extends Config> {
    private final T config;
    private class_437 screen;

    public ConfigSupplier(T config) {
        this.config = config;
    }

    public class_437 build(class_437 parent) {
        ArrayList<UIElement> elements = new ArrayList<UIElement>();
        for (Field field : this.getFields()) {
            this.processBoolean(field, elements);
            this.processEnum(field, elements);
            this.processItemList(field, elements);
        }
        this.screen = new GeneratedConfigScreen((Config)this.config, (List<UIElement>)elements, parent);
        return this.screen;
    }

    private void processItemList(Field field, List<UIElement> elements) {
        if (!ItemList.class.isAssignableFrom(field.getType())) {
            return;
        }
        String key = "setting." + this.config.getModId() + "." + field.getName();
        field.setAccessible(true);
        elements.add(new ItemListEditorButton((Config)this.config, key, cfg -> {
            try {
                return (ItemList)field.get(cfg);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return new ItemList();
            }
        }, (cfg, value) -> {
            try {
                field.set(cfg, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }));
    }

    private void processEnum(Field field, List<UIElement> elements) {
        Class<?> enumClass = field.getType();
        if (!field.getType().isEnum()) {
            return;
        }
        String key = "setting." + this.config.getModId() + "." + field.getName();
        field.setAccessible(true);
        EnumCyclerButton<Object> button = new EnumCyclerButton<Object>((Config)this.config, key, (Class<Object>)enumClass, (Function<Config, Object>)((Function<Object, Object>)c -> {
            try {
                return field.get(c);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }), (BiConsumer<Config, Object>)((BiConsumer<Object, Object>)(c, v) -> {
            try {
                field.set(c, v);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }));
        elements.add(button);
    }

    private void processBoolean(Field field, List<UIElement> elements) {
        if (!field.getType().equals(Boolean.TYPE) && !field.getType().equals(Boolean.class)) {
            return;
        }
        int type = 0;
        if (field.isAnnotationPresent(BooleanSetting.class)) {
            type = field.getAnnotation(BooleanSetting.class).type();
        }
        field.setAccessible(true);
        String key = "setting." + this.config.getModId() + "." + field.getName();
        BooleanButton booleanButton = new BooleanButton((Config)this.config, key, type, i -> {
            try {
                return (Boolean)field.get(i);
            }
            catch (IllegalAccessException e) {
                AutoConfigAPI.LOGGER.error("Could not get field {}: {}", (Object)field.getName(), (Object)e);
                return null;
            }
        }, (i, v) -> {
            try {
                field.set(i, v);
            }
            catch (IllegalAccessException e) {
                AutoConfigAPI.LOGGER.error("Could not set field {}: {}", (Object)field.getName(), (Object)e);
            }
        });
        elements.add(booleanButton);
    }

    public List<Field> getFields() {
        ArrayList<Field> elements = new ArrayList<Field>();
        for (Field field : this.config.getClass().getFields()) {
            if (!field.isAnnotationPresent(Setting.class) || (field.getModifiers() & 0x10) != 0) continue;
            elements.add(field);
        }
        return elements;
    }

    public class_437 getScreenIfBuilt() {
        return this.screen;
    }

    @Generated
    public T getConfig() {
        return this.config;
    }
}

