/*
 * Decompiled with CFR 0.152.
 */
package dev.dokko.autoconfig.api.config.serialize.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import dev.dokko.autoconfig.AutoConfigAPI;
import dev.dokko.autoconfig.api.AutoConfig;
import dev.dokko.autoconfig.api.config.Config;
import dev.dokko.autoconfig.api.config.serialize.ConfigSerializer;
import dev.dokko.autoconfig.api.setting.ItemList;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class JsonSerializer<T extends Config>
implements ConfigSerializer<T> {
    private final T config;

    public JsonSerializer(T config) {
        this.config = config;
    }

    @Override
    public String serialize() throws Exception {
        this.getFile().toFile().getParentFile().mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject element = new JsonObject();
        List<Field> fields = AutoConfig.getSupplier(this.config.getClass()).getFields();
        for (Field field : fields) {
            String name = field.getName();
            field.setAccessible(true);
            Object value = field.get(this.config);
            if (value == null) continue;
            if (value instanceof String) {
                element.addProperty(name, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                element.addProperty(name, (Boolean)value);
                continue;
            }
            if (value instanceof Number) {
                element.addProperty(name, (Number)value);
                continue;
            }
            if (value instanceof Enum) {
                element.addProperty(name, ((Enum)value).name().toLowerCase());
                continue;
            }
            if (value instanceof ItemList) {
                JsonObject jsonObj = new JsonObject();
                this.addItemList(jsonObj, (ItemList)value);
                element.add(name, (JsonElement)jsonObj);
                continue;
            }
            if (value instanceof class_2960) {
                element.addProperty(name, value.toString());
                continue;
            }
            if (value instanceof class_1792) {
                element.addProperty(name, class_7923.field_41178.method_10221((Object)((class_1792)value)).toString());
                continue;
            }
            if (value instanceof Collection) {
                JsonArray array = new JsonArray();
                for (Object e : (Collection)value) {
                    array.add(gson.toJsonTree(e));
                }
                element.add(name, (JsonElement)array);
                continue;
            }
            if (value instanceof Map) {
                JsonObject obj = new JsonObject();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    obj.add(entry.getKey().toString(), gson.toJsonTree(entry.getValue()));
                }
                element.add(name, (JsonElement)obj);
                continue;
            }
            element.add(name, gson.toJsonTree(value));
        }
        return gson.toJson((JsonElement)element);
    }

    private void addItemList(JsonObject jsonObj, ItemList list) {
        jsonObj.addProperty("type", "ItemList");
        JsonArray items = new JsonArray();
        for (class_1792 item : list.items) {
            items.add(class_7923.field_41178.method_10221((Object)item).toString());
        }
        jsonObj.add("items", (JsonElement)items);
        jsonObj.addProperty("invert", Boolean.valueOf(list.invert));
    }

    @Override
    public void deserialize(String contents) {
        if (contents == null || contents.trim().isEmpty()) {
            return;
        }
        Path filePath = this.getFile();
        filePath.toFile().getParentFile().mkdirs();
        Gson gson = new Gson();
        try {
            JsonObject jsonObject = JsonParser.parseString((String)contents).getAsJsonObject();
            for (String key : jsonObject.keySet()) {
                try {
                    Field field = this.config.getClass().getDeclaredField(key);
                    field.setAccessible(true);
                    Class<?> type = field.getType();
                    JsonElement element = jsonObject.get(key);
                    if (element.isJsonObject() && element.getAsJsonObject().has("type") && element.getAsJsonObject().get("type").getAsString().equals("ItemList")) {
                        ArrayList<class_1792> items = new ArrayList<class_1792>();
                        for (JsonElement itemEl : element.getAsJsonObject().getAsJsonArray("items")) {
                            items.add((class_1792)class_7923.field_41178.method_10223(new class_2960(itemEl.getAsString())));
                        }
                        boolean invert = element.getAsJsonObject().get("invert").getAsBoolean();
                        field.set(this.config, new ItemList(items, invert));
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(type)) {
                        Class<?> enumType = type;
                        Object value = Enum.valueOf(enumType, element.getAsString().toUpperCase());
                        field.set(this.config, value);
                        continue;
                    }
                    if (type.equals(class_1792.class)) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(element.getAsString()));
                        field.set(this.config, item);
                        continue;
                    }
                    if (type.equals(class_2960.class)) {
                        field.set(this.config, new class_2960(element.getAsString()));
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(type)) {
                        Type genericType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{(Class)genericType}).getType();
                        Object list = gson.fromJson(element, listType);
                        field.set(this.config, list);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(type)) {
                        Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                        Type mapType = TypeToken.getParameterized(Map.class, (Type[])types).getType();
                        Object map = gson.fromJson(element, mapType);
                        field.set(this.config, map);
                        continue;
                    }
                    Object value = gson.fromJson(element, type);
                    field.set(this.config, value);
                }
                catch (NoSuchFieldException e) {
                    AutoConfigAPI.LOGGER.warn("Unknown config field: {}", (Object)key);
                }
                catch (Exception e) {
                    AutoConfigAPI.LOGGER.warn("Could not set field \"{}\":", (Object)key);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            AutoConfigAPI.LOGGER.error("Failed to deserialize config JSON:");
            e.printStackTrace();
        }
    }

    @Override
    public String getFileName() {
        return this.config.getModId() + ".json";
    }
}

