/*
 * Decompiled with CFR 0.152.
 */
package dev.dokko.autoconfig.api.ui.element;

import dev.dokko.autoconfig.api.config.Config;
import dev.dokko.autoconfig.api.ui.element.UIElement;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class EnumCyclerButton<E extends Enum<E>>
implements UIElement {
    private final Config config;
    private final String key;
    private final Class<E> enumClass;
    private final E defaultValue;
    private final Function<Config, E> getter;
    private final BiConsumer<Config, E> setter;

    public EnumCyclerButton(Config config, String key, Class<E> enumClass, Function<Config, E> getter, BiConsumer<Config, E> setter) {
        this.config = config;
        this.key = key;
        this.enumClass = enumClass;
        this.getter = getter;
        this.setter = setter;
        this.defaultValue = (Enum)getter.apply(config);
    }

    @Override
    public class_339 build(int x, int y, int width, int height) {
        return class_4185.method_46430((class_2561)this.getMessage(), button -> {
            Enum currentValue = (Enum)this.getter.apply(this.config);
            if (class_437.method_25442()) {
                this.setter.accept(this.config, this.defaultValue);
                button.method_25355(this.getMessage());
                return;
            }
            Enum[] values = (Enum[])this.enumClass.getEnumConstants();
            int currentIndex = currentValue.ordinal();
            int nextIndex = (currentIndex + 1) % values.length;
            this.setter.accept(this.config, values[nextIndex]);
            button.method_25355(this.getMessage());
        }).method_46434(x, y, width, height).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.key + ".tooltip")))).method_46431();
    }

    private class_2561 getMessage() {
        Enum value = (Enum)this.getter.apply(this.config);
        return class_2561.method_43471((String)this.key).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.formatEnum(value)).method_27692(class_124.field_1075));
    }

    private String formatEnum(E value) {
        return ((Enum)value).name().charAt(0) + ((Enum)value).name().substring(1).toLowerCase();
    }
}

