/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.economyGUI;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import ru.stepanyaa.economyGUI.EconomySearchGUI;
import ru.stepanyaa.economyGUI.bukkit.Metrics;

public class EconomyGUI
extends JavaPlugin
implements CommandExecutor,
TabCompleter {
    private Economy econ = null;
    private FileConfiguration messagesConfig;
    private FileConfiguration transactionsConfig;
    private File transactionsFile;
    private String language;
    private static final String CURRENT_VERSION = "1.0.2";
    private EconomySearchGUI economySearchGUI;
    private final Set<String> adminUUIDs = ConcurrentHashMap.newKeySet();
    private String latestVersion = null;
    private boolean playerSelectionEnabled;
    private boolean massOperationsEnabled;
    private boolean quickActionsEnabled;
    private boolean fullManagementEnabled;
    public int transactionRetentionDays;
    private boolean isFirstEnable = true;
    private File messagesFile;

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe(this.getMessage("warning.no-economy", "Economy provider not found! Disabling plugin."));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.updateConfigFile();
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.playerSelectionEnabled = this.getConfig().getBoolean("features.player-selection", true);
        this.massOperationsEnabled = this.getConfig().getBoolean("features.mass-operations", true);
        this.quickActionsEnabled = this.getConfig().getBoolean("features.quick-actions", true);
        this.fullManagementEnabled = this.getConfig().getBoolean("features.full-management", true);
        this.transactionRetentionDays = this.getConfig().getInt("features.transaction-retention-days", 30);
        this.loadMessages();
        if (this.messagesConfig == null) {
            this.getLogger().severe("Failed to load messages configuration. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!(this.playerSelectionEnabled || this.massOperationsEnabled || this.quickActionsEnabled || this.fullManagementEnabled)) {
            this.getLogger().warning(this.getMessage("error.all-features-disabled", "All features are disabled in config! Commands will be limited."));
        }
        this.economySearchGUI = new EconomySearchGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.economySearchGUI, (Plugin)this);
        this.loadTransactions();
        PluginCommand command = this.getCommand("economygui");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setPermissionMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
        } else {
            this.getLogger().warning("Failed to register command 'economygui'!");
        }
        this.adminUUIDs.addAll(this.getConfig().getStringList("admin-uuids"));
        this.getLogger().info(this.getMessage("warning.plugin-enabled", "EconomyGUI enabled with language: %lang%", "lang", this.language));
        this.checkForUpdates();
        this.isFirstEnable = false;
        int pluginId = 27776;
        Metrics metrics = new Metrics(this, pluginId);
    }

    public void onDisable() {
        this.saveTransactions();
        this.getLogger().info("EconomyGUI disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    private void loadMessages() {
        String messagesFileName = "messages_" + this.language + ".yml";
        this.messagesFile = new File(this.getDataFolder(), messagesFileName);
        try {
            if (!this.messagesFile.exists()) {
                if (this.getResource(messagesFileName) != null) {
                    this.saveResource(messagesFileName, false);
                    this.getLogger().info("Created messages file: " + messagesFileName);
                } else {
                    this.getLogger().warning("Messages file " + messagesFileName + " not found in plugin!");
                    this.messagesConfig = new YamlConfiguration();
                    return;
                }
            }
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            String currentFileVersion = this.messagesConfig.getString("version", "0.0.0");
            if (!currentFileVersion.equals(CURRENT_VERSION)) {
                if (this.getResource(messagesFileName) != null) {
                    File backupFile = new File(this.getDataFolder(), messagesFileName + ".backup");
                    if (this.messagesFile.renameTo(backupFile)) {
                        this.getLogger().info("Backed up old messages file to: " + messagesFileName + ".backup");
                    }
                    this.saveResource(messagesFileName, true);
                    this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
                    this.messagesConfig.set("version", (Object)CURRENT_VERSION);
                    this.messagesConfig.save(this.messagesFile);
                    this.getLogger().info("Updated messages file " + messagesFileName + " to version " + CURRENT_VERSION);
                } else {
                    this.getLogger().warning("Resource " + messagesFileName + " not found in plugin!");
                }
            } else if (this.isFirstEnable) {
                this.getLogger().info("Messages file " + messagesFileName + " is up-to-date (version " + CURRENT_VERSION + ").");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
            this.messagesConfig = new YamlConfiguration();
        }
    }

    private void loadTransactions() {
        this.transactionsFile = new File(this.getDataFolder(), "transactions.yml");
        if (!this.transactionsFile.exists()) {
            try {
                this.transactionsFile.createNewFile();
                this.getLogger().info("Created transactions file: transactions.yml");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create transactions.yml: " + e.getMessage());
            }
        }
        this.transactionsConfig = YamlConfiguration.loadConfiguration((File)this.transactionsFile);
        this.economySearchGUI.loadTransactionHistory(this.transactionsConfig);
    }

    public void saveTransactions() {
        this.economySearchGUI.cleanOldTransactions();
        this.economySearchGUI.saveTransactionHistory(this.transactionsConfig);
        try {
            this.transactionsConfig.save(this.transactionsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save transactions.yml: " + e.getMessage());
        }
    }

    public String getMessage(String key) {
        if (this.messagesConfig == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)key);
        }
        String msg = this.messagesConfig.getString(key, key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getMessage(String key, String def) {
        if (this.messagesConfig == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)def);
        }
        String msg = this.messagesConfig.getString(key, def);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getMessage(String key, String def, Object ... placeholders) {
        String msg = this.getMessage(key, def);
        if (placeholders != null && placeholders.length >= 2 && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                String placeholder = placeholders[i].toString();
                String value = placeholders[i + 1].toString();
                msg = msg.replace("%" + placeholder + "%", value);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.player-only", "This command is for players only!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("economygui.admin") && !player.hasPermission("economygui.gui")) {
            player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("gui")) {
            if (args.length > 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage-gui", "Usage: /economygui gui"));
                return true;
            }
            this.economySearchGUI.openLastGUIMenu(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("economygui.reload")) {
                player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage-reload", "Usage: /economygui reload"));
                return true;
            }
            this.reloadPlugin(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reset")) {
            if (!player.hasPermission("economygui.reset")) {
                player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /economygui reset"));
                return true;
            }
            this.economySearchGUI.resetSearch(player);
            return true;
        }
        player.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /economygui <gui | reload | reset>"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("gui", "reload", "reset").stream().filter(cmd -> sender.hasPermission("economygui." + cmd) || sender.hasPermission("economygui.admin")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void reloadPlugin(Player player) {
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.loadMessages();
        this.loadTransactions();
        this.updateConfigFile();
        this.transactionRetentionDays = this.getConfig().getInt("features.transaction-retention-days", 30);
        this.playerSelectionEnabled = this.getConfig().getBoolean("features.player-selection", true);
        this.massOperationsEnabled = this.getConfig().getBoolean("features.mass-operations", true);
        this.quickActionsEnabled = this.getConfig().getBoolean("features.quick-actions", true);
        this.fullManagementEnabled = this.getConfig().getBoolean("features.full-management", true);
        this.economySearchGUI.refreshOpenGUIs();
        this.economySearchGUI.cleanOldTransactions();
        player.sendMessage(ChatColor.GREEN + this.getMessage("action.config-reloaded", "Configuration reloaded."));
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/economygui/version");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "EconomyGUI/1.0.2");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    JsonArray versions = JsonParser.parseReader(new InputStreamReader(conn.getInputStream())).getAsJsonArray();
                    String highestVersion = null;
                    for (JsonElement element : versions) {
                        String versionNumber = element.getAsJsonObject().get("version_number").getAsString();
                        String versionType = element.getAsJsonObject().get("version_type").getAsString();
                        if (versionNumber.contains("-SNAPSHOT") && !versionType.equals("release") || highestVersion != null && !this.isNewerVersion(versionNumber, highestVersion)) continue;
                        highestVersion = versionNumber;
                    }
                    if (highestVersion != null && this.isNewerVersion(highestVersion, CURRENT_VERSION)) {
                        String[] currentParts = CURRENT_VERSION.split("\\.");
                        String[] highestParts = highestVersion.split("\\.");
                        if (currentParts.length == 3 && highestParts.length == 3) {
                            int currentMajor = Integer.parseInt(currentParts[0]);
                            int currentMinor = Integer.parseInt(currentParts[1]);
                            int currentPatch = Integer.parseInt(currentParts[2]);
                            int highestMajor = Integer.parseInt(highestParts[0]);
                            int highestMinor = Integer.parseInt(highestParts[1]);
                            int highestPatch = Integer.parseInt(highestParts[2]);
                            if (currentMajor == highestMajor && currentMinor == highestMinor && highestPatch == currentPatch + 1) {
                                this.latestVersion = highestVersion;
                                this.getLogger().warning("*** UPDATE AVAILABLE *** A new version of EconomyGUI (" + this.latestVersion + ") is available at:\nhttps://modrinth.com/plugin/economygui/versions");
                            }
                        }
                    }
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private boolean isNewerVersion(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        for (int i = 0; i < Math.min(parts1.length, parts2.length); ++i) {
            int num2;
            int num1 = Integer.parseInt(parts1[i]);
            if (num1 > (num2 = Integer.parseInt(parts2[i]))) {
                return true;
            }
            if (num1 >= num2) continue;
            return false;
        }
        return parts1.length > parts2.length;
    }

    private void updateConfigFile() {
        YamlConfiguration existingConfig;
        String currentFileVersion;
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
            this.getLogger().info(this.getMessage("warning.config-file-create", "Created config file: config.yml"));
        }
        if ((currentFileVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)configFile)).getString("config-version", "0.0.0")).equals(CURRENT_VERSION)) {
            if (this.isFirstEnable) {
                this.getLogger().info(this.getMessage("warning.config-file-up-to-date", "Config file config.yml is up-to-date (version %version%).").replace("%version%", CURRENT_VERSION));
            }
            return;
        }
        if (this.getResource("config.yml") != null) {
            try {
                this.saveResource("config.yml", true);
                this.getLogger().info(this.getMessage("warning.config-file-updated", "Updated config.yml to version %version%.").replace("%version%", CURRENT_VERSION));
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
                newConfig.set("config-version", (Object)CURRENT_VERSION);
                newConfig.save(configFile);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to update config.yml: " + e.getMessage());
            }
        } else {
            this.getLogger().warning(this.getMessage("warning.config-file-not-found", "Resource config.yml not found in plugin!"));
        }
    }

    public boolean isPlayerSelectionEnabled() {
        return this.playerSelectionEnabled;
    }

    public boolean isMassOperationsEnabled() {
        return this.massOperationsEnabled;
    }

    public boolean isQuickActionsEnabled() {
        return this.quickActionsEnabled;
    }

    public boolean isFullManagementEnabled() {
        return this.fullManagementEnabled;
    }

    public Set<String> getAdminUUIDs() {
        return this.adminUUIDs;
    }
}

