/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.economyGUI;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import ru.stepanyaa.economyGUI.EconomyGUI;

public class EconomySearchGUI
implements Listener,
InventoryHolder {
    private final Map<String, List<Transaction>> transactionHistory = new ConcurrentHashMap<String, List<Transaction>>();
    private static final long PAGE_SWITCH_COOLDOWN = 1000L;
    private final EconomyGUI plugin;
    private Inventory inventory;
    private int currentPage = 0;
    private String currentSearch = "";
    private Filter currentFilter = Filter.ALL;
    private final Set<UUID> selectedPlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Set<UUID>> playerSelections = new ConcurrentHashMap<UUID, Set<UUID>>();
    private final Map<UUID, String> lastOpenedMenu = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Integer> lastPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, String> lastTarget = new ConcurrentHashMap<UUID, String>();
    private final Set<UUID> playersInGUI = ConcurrentHashMap.newKeySet();
    private final Map<UUID, ChatAction> pendingActions = new ConcurrentHashMap<UUID, ChatAction>();
    private final Map<UUID, String> pendingActionType = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Double> pendingActionAmount = new ConcurrentHashMap<UUID, Double>();
    private final Map<UUID, PlayerResult> pendingActionTarget = new ConcurrentHashMap<UUID, PlayerResult>();
    private List<PlayerResult> cachedResults = new ArrayList<PlayerResult>();
    private String moneyFormat;
    private boolean usePlaceholderAPI;
    private final Map<UUID, Long> lastPageSwitch = new ConcurrentHashMap<UUID, Long>();

    public EconomySearchGUI(EconomyGUI plugin) {
        this.plugin = plugin;
        this.usePlaceholderAPI = plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.moneyFormat = "%,.2f";
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_PURPLE + plugin.getMessage("gui.title", "Economy Management")));
        this.refreshGUI();
    }

    private void refreshGUI() {
        this.setupMainMenuLayout();
    }

    private void setupMainMenuLayout() {
        this.inventory.clear();
        for (int slot = 0; slot < 9; ++slot) {
            this.inventory.setItem(slot, new ItemStack(Material.AIR));
        }
        ItemStack searchItem = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = searchItem.getItemMeta();
        searchMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.search", "Search: %search_query%", "search_query", this.currentSearch.isEmpty() ? this.plugin.getMessage("gui.search-all", "all") : this.currentSearch));
        ArrayList<String> searchLore = new ArrayList<String>();
        searchLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.search-hint", "Left click: Enter query | Right click: Reset search | Shift+Left: Select/Deselect"));
        searchMeta.setLore(searchLore);
        searchItem.setItemMeta(searchMeta);
        this.inventory.setItem(4, searchItem);
        this.inventory.setItem(49, this.createFilterItem(Filter.ALL));
        this.inventory.setItem(50, this.createFilterItem(Filter.ONLINE));
        this.inventory.setItem(51, this.createFilterItem(Filter.OFFLINE));
        if (this.plugin.isMassOperationsEnabled()) {
            ItemStack massItem = new ItemStack(Material.DIAMOND_BLOCK);
            ItemMeta massMeta = massItem.getItemMeta();
            massMeta.setDisplayName(ChatColor.AQUA + this.plugin.getMessage("gui.mass-menu-title", "Mass Operations"));
            ArrayList<String> massLore = new ArrayList<String>();
            massLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-hint", "Click for mass give/take/set (select players first)"));
            massMeta.setLore(massLore);
            massItem.setItemMeta(massMeta);
            this.inventory.setItem(48, massItem);
        }
        int totalPages = this.cachedResults.size() / 36 + (this.cachedResults.size() % 36 > 0 ? 1 : 0);
        int currentPageNum = this.currentPage + 1;
        ItemStack prev = this.currentPage > 0 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta prevMeta = prev.getItemMeta();
        prevMeta.setDisplayName(this.currentPage > 0 ? ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> prevLore = new ArrayList<String>();
        prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(currentPageNum), "total_pages", String.valueOf(totalPages)));
        if (this.currentPage > 0) {
            prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
        }
        prevMeta.setLore(prevLore);
        prev.setItemMeta(prevMeta);
        this.inventory.setItem(45, prev);
        ItemStack next = this.currentPage < totalPages - 1 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta nextMeta = next.getItemMeta();
        nextMeta.setDisplayName(this.currentPage < totalPages - 1 ? ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> nextLore = new ArrayList<String>();
        nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(currentPageNum), "total_pages", String.valueOf(totalPages)));
        if (this.currentPage < totalPages - 1) {
            nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
        }
        nextMeta.setLore(nextLore);
        next.setItemMeta(nextMeta);
        this.inventory.setItem(53, next);
        if (this.plugin.isPlayerSelectionEnabled()) {
            ItemStack selectBtn = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta selectMeta = selectBtn.getItemMeta();
            selectMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.select-all", "Select All"));
            ArrayList<String> selectLore = new ArrayList<String>();
            selectLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-select", "Click to select all on page"));
            selectMeta.setLore(selectLore);
            selectBtn.setItemMeta(selectMeta);
            this.inventory.setItem(46, selectBtn);
            ItemStack cancelBtn = new ItemStack(Material.REDSTONE_BLOCK);
            ItemMeta cancelMeta = cancelBtn.getItemMeta();
            cancelMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.cancel-selection", "Cancel Selection"));
            ArrayList<String> cancelLore = new ArrayList<String>();
            cancelLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-cancel", "Click to cancel all selections"));
            cancelMeta.setLore(cancelLore);
            cancelBtn.setItemMeta(cancelMeta);
            this.inventory.setItem(47, cancelBtn);
        }
        List<PlayerResult> results = this.getFilteredPlayers();
        this.cachedResults = results;
        int start = this.currentPage * 36;
        int end = Math.min(start + 36, results.size());
        for (int i = start; i < end; ++i) {
            PlayerResult result = results.get(i);
            OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
            ItemStack head = this.createPlayerHead(offPlayer, i);
            int slot = 9 + (i - start);
            this.inventory.setItem(slot, head);
        }
        if (results.isEmpty()) {
            ItemStack noPlayers = new ItemStack(Material.BARRIER);
            ItemMeta meta = noPlayers.getItemMeta();
            meta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-players", "No players found"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.no-players-hint", "Try changing the search or filter"));
            meta.setLore(lore);
            noPlayers.setItemMeta(meta);
            this.inventory.setItem(22, noPlayers);
        }
    }

    private ItemStack createFilterItem(Filter filter) {
        String displayName;
        Material mat;
        switch (filter.ordinal()) {
            case 0: {
                mat = Material.COMPASS;
                break;
            }
            case 1: {
                mat = Material.LIME_DYE;
                break;
            }
            case 2: {
                mat = Material.GRAY_DYE;
                break;
            }
            default: {
                mat = Material.PAPER;
            }
        }
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        switch (filter.ordinal()) {
            case 0: {
                displayName = ChatColor.WHITE + this.plugin.getMessage("filter.all", "All Players");
                break;
            }
            case 1: {
                displayName = ChatColor.GREEN + this.plugin.getMessage("filter.online", "Online Players");
                break;
            }
            case 2: {
                displayName = ChatColor.GRAY + this.plugin.getMessage("filter.offline", "Offline Players");
                break;
            }
            default: {
                displayName = ChatColor.GRAY + "Unknown";
            }
        }
        meta.setDisplayName(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + this.plugin.getMessage("filter.filter-hint", "Click to apply filter"));
        if (this.currentFilter == filter) {
            lore.add(ChatColor.GREEN + this.plugin.getMessage("filter.filter-active", "\u2713 Active filter"));
            meta.addEnchant(this.getGlowEnchantment(), 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(OfflinePlayer player, int index) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(player);
        meta.setDisplayName(ChatColor.YELLOW + player.getName());
        ArrayList<String> lore = new ArrayList<String>();
        double balance = this.plugin.getEconomy().getBalance(player);
        String formattedBalance = String.format(this.moneyFormat, balance);
        lore.add(ChatColor.GOLD + this.plugin.getMessage("gui.balance", "Balance: $%balance%", "balance", formattedBalance));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions", "Left click: Manage | Right click: Quick Actions | Shift+Left: Select"));
        if (this.isSelected(player.getUniqueId().toString())) {
            lore.add(ChatColor.GREEN + this.plugin.getMessage("gui.selected", "Selected"));
            meta.addEnchant(this.getGlowEnchantment(), 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.setLore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private Enchantment getGlowEnchantment() {
        String version = Bukkit.getBukkitVersion();
        return version.contains("1.16") ? Enchantment.DURABILITY : Enchantment.VANISHING_CURSE;
    }

    private boolean isSelected(String uuid) {
        return this.selectedPlayers.contains(UUID.fromString(uuid));
    }

    private void applyFilter(Filter newFilter, Player player) {
        this.currentFilter = newFilter;
        this.currentPage = 0;
        this.lastPage.put(player.getUniqueId(), 0);
        this.refreshGUI();
        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("filter.applied", "Filter applied: " + newFilter.name()));
    }

    private void openPlayerFinanceManagement(Player player, PlayerResult result) {
        Inventory financeInv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.title", "Economy Management") + ": " + result.name));
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
        financeInv.setItem(4, this.createPlayerHead(target, 0));
        ItemStack inputField = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta inputMeta = inputField.getItemMeta();
        inputMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter Amount"));
        ArrayList<String> inputLore = new ArrayList<String>();
        inputLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-amount-hint", "Left click to enter amount in chat"));
        inputMeta.setLore(inputLore);
        inputField.setItemMeta(inputMeta);
        financeInv.setItem(13, inputField);
        ItemStack giveBtn = new ItemStack(Material.EMERALD);
        ItemMeta giveMeta = giveBtn.getItemMeta();
        giveMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("action.give", "Give Amount"));
        ArrayList<String> giveLore = new ArrayList<String>();
        giveLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.give-hint", "Click to open digital menu"));
        giveMeta.setLore(giveLore);
        giveBtn.setItemMeta(giveMeta);
        financeInv.setItem(20, giveBtn);
        ItemStack takeBtn = new ItemStack(Material.REDSTONE);
        ItemMeta takeMeta = takeBtn.getItemMeta();
        takeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("action.take", "Take Amount"));
        ArrayList<String> takeLore = new ArrayList<String>();
        takeLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.take-hint", "Click to open digital menu"));
        takeMeta.setLore(takeLore);
        takeBtn.setItemMeta(takeMeta);
        financeInv.setItem(22, takeBtn);
        ItemStack setBtn = new ItemStack(Material.GOLD_INGOT);
        ItemMeta setMeta = setBtn.getItemMeta();
        setMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("action.set", "Set Amount"));
        ArrayList<String> setLore = new ArrayList<String>();
        setLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.set-hint", "Click to enter amount in chat"));
        setMeta.setLore(setLore);
        setBtn.setItemMeta(setMeta);
        financeInv.setItem(24, setBtn);
        ItemStack historyBtn = new ItemStack(Material.BOOK);
        ItemMeta historyMeta = historyBtn.getItemMeta();
        historyMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("history.operations", "Operations History"));
        ArrayList<String> historyLore = new ArrayList<String>();
        historyLore.add(ChatColor.GRAY + this.plugin.getMessage("history.hint", "Click to view logs"));
        historyMeta.setLore(historyLore);
        historyBtn.setItemMeta(historyMeta);
        financeInv.setItem(31, historyBtn);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.back-hint", "Return to main menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        financeInv.setItem(49, backBtn);
        player.openInventory(financeInv);
        this.lastOpenedMenu.put(player.getUniqueId(), "finance");
        this.lastTarget.put(player.getUniqueId(), result.name);
    }

    private void openContextMenu(Player player, String targetName) {
        PlayerResult result = this.getPlayerResultByName(targetName);
        if (result == null) {
            return;
        }
        Inventory contextInv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.BLUE + this.plugin.getMessage("context-menu.title", "Quick Actions for %player%", "player", targetName)));
        this.lastOpenedMenu.put(player.getUniqueId(), "context");
        this.lastTarget.put(player.getUniqueId(), targetName);
        contextInv.setItem(10, this.createQuickActionItem("Give $100", "give", 100.0, result));
        contextInv.setItem(11, this.createQuickActionItem("Give $1000", "give", 1000.0, result));
        contextInv.setItem(12, this.createQuickActionItem("Take $100", "take", 100.0, result));
        contextInv.setItem(13, this.createQuickActionItem("Take $1000", "take", 1000.0, result));
        contextInv.setItem(14, this.createQuickActionItem("Set $5000", "set", 5000.0, result));
        contextInv.setItem(15, this.createQuickActionItem("Reset to $0", "set", 0.0, result));
        contextInv.setItem(16, this.createQuickActionItem("Custom Amount", "custom", 0.0, result));
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = back.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("context-menu.back", "Back to Main Menu"));
        back.setItemMeta(backMeta);
        contextInv.setItem(22, back);
        if (this.plugin.isFullManagementEnabled()) {
            ItemStack full = new ItemStack(Material.BOOK);
            ItemMeta fullMeta = full.getItemMeta();
            fullMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("context-menu.full-open", "Open Full Management"));
            full.setItemMeta(fullMeta);
            contextInv.setItem(4, full);
        }
        player.openInventory(contextInv);
    }

    private ItemStack createQuickActionItem(String name, String action, double amount, PlayerResult result) {
        ItemStack item = new ItemStack(action.equals("give") ? Material.EMERALD : (action.equals("take") ? Material.REDSTONE : Material.GOLD_INGOT));
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + name);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + "Click to apply to " + result.name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void openDigitalMenu(Player player, String action, PlayerResult result) {
        Inventory digitalInv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.title", "Economy Management") + ": " + result.name));
        double totalAmount = this.pendingActionAmount.getOrDefault(player.getUniqueId(), 0.0);
        digitalInv.setItem(4, this.createPlayerHead(Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid)), 0));
        int[] amounts = new int[]{1, 5, 10, 100, 1000, 5000};
        int slot = 9;
        for (int amount : amounts) {
            ItemStack numBtn = new ItemStack(Material.PAPER);
            ItemMeta numMeta = numBtn.getItemMeta();
            numMeta.setDisplayName(ChatColor.YELLOW + String.valueOf(amount));
            ArrayList<String> numLore = new ArrayList<String>();
            numLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.add-amount-hint", "Click to add %amount% to total", "amount", String.valueOf(amount)));
            numLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
            numMeta.setLore(numLore);
            numBtn.setItemMeta(numMeta);
            digitalInv.setItem(slot, numBtn);
            ++slot;
        }
        ItemStack customBtn = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta customMeta = customBtn.getItemMeta();
        customMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("gui.custom-amount", "Custom Amount"));
        ArrayList<String> customLore = new ArrayList<String>();
        customLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.custom-amount-hint", "Left click to enter custom amount in chat"));
        customLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
        customMeta.setLore(customLore);
        customBtn.setItemMeta(customMeta);
        digitalInv.setItem(22, customBtn);
        ItemStack resetBtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta resetMeta = resetBtn.getItemMeta();
        resetMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reset-amount", "Reset Amount"));
        ArrayList<String> resetLore = new ArrayList<String>();
        resetLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.reset-amount-hint", "Reset the selected amount to 0"));
        resetLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
        resetMeta.setLore(resetLore);
        resetBtn.setItemMeta(resetMeta);
        digitalInv.setItem(18, resetBtn);
        ItemStack confirmBtn = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta confirmMeta = confirmBtn.getItemMeta();
        confirmMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.confirm", "Confirm"));
        ArrayList<String> confirmLore = new ArrayList<String>();
        confirmLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.confirm-hint", "Execute: %action% $%amount%", "action", action, "amount", String.format(this.moneyFormat, totalAmount)));
        confirmMeta.setLore(confirmLore);
        confirmBtn.setItemMeta(confirmMeta);
        digitalInv.setItem(16, confirmBtn);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.back-hint-finance", "Return to finance menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        digitalInv.setItem(26, backBtn);
        player.openInventory(digitalInv);
        this.pendingActionType.put(player.getUniqueId(), action);
        this.pendingActionTarget.put(player.getUniqueId(), result);
        this.lastOpenedMenu.put(player.getUniqueId(), "digital");
    }

    private void openHistoryMenu(Player player, PlayerResult result) {
        String uuid = result.uuid;
        List history = this.transactionHistory.getOrDefault(uuid, new ArrayList());
        history.sort(Comparator.comparingLong(t -> -t.timestamp));
        Inventory historyInv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.GOLD + this.plugin.getMessage("gui.history", "Operations History") + ": " + result.name));
        this.lastOpenedMenu.put(player.getUniqueId(), "history");
        this.lastTarget.put(player.getUniqueId(), result.name);
        int page = this.lastPage.getOrDefault(player.getUniqueId(), 0);
        int start = page * 45;
        int end = Math.min(start + 45, history.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = start; i < end; ++i) {
            Transaction t2 = (Transaction)history.get(i);
            ItemStack item = new ItemStack(Material.PAPER);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.YELLOW + t2.action.toUpperCase() + " $" + String.format(this.moneyFormat, t2.amount));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + "By: " + t2.executor);
            lore.add(ChatColor.GRAY + "Date: " + sdf.format(new Date(t2.timestamp)));
            meta.setLore(lore);
            item.setItemMeta(meta);
            historyInv.setItem(i - start, item);
        }
        if (history.isEmpty()) {
            ItemStack noHistory = new ItemStack(Material.BARRIER);
            ItemMeta noMeta = noHistory.getItemMeta();
            noMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-players", "No transactions found"));
            noHistory.setItemMeta(noMeta);
            historyInv.setItem(22, noHistory);
        }
        int totalPages = history.size() / 45 + (history.size() % 45 > 0 ? 1 : 0);
        ItemStack prev = page > 0 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta prevMeta = prev.getItemMeta();
        prevMeta.setDisplayName(page > 0 ? ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> prevLore = new ArrayList<String>();
        prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(page + 1), "total_pages", String.valueOf(totalPages)));
        prevMeta.setLore(prevLore);
        prev.setItemMeta(prevMeta);
        historyInv.setItem(45, prev);
        ItemStack next = page < totalPages - 1 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta nextMeta = next.getItemMeta();
        nextMeta.setDisplayName(page < totalPages - 1 ? ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> nextLore = new ArrayList<String>();
        nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(page + 1), "total_pages", String.valueOf(totalPages)));
        nextMeta.setLore(nextLore);
        next.setItemMeta(nextMeta);
        historyInv.setItem(53, next);
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = back.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        back.setItemMeta(backMeta);
        historyInv.setItem(49, back);
        player.openInventory(historyInv);
    }

    private void openMassActionsMenu(Player player) {
        Inventory massInv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.mass-menu-title", "Mass Operations")));
        ItemStack giveMass = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta giveMeta = giveMass.getItemMeta();
        giveMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.mass-give", "Give Amount to All Selected"));
        ArrayList<String> giveLore = new ArrayList<String>();
        giveLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-give-hint", "Click to enter amount for all"));
        giveMeta.setLore(giveLore);
        giveMass.setItemMeta(giveMeta);
        massInv.setItem(11, giveMass);
        ItemStack takeMass = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta takeMeta = takeMass.getItemMeta();
        takeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.mass-take", "Take Amount from All Selected"));
        ArrayList<String> takeLore = new ArrayList<String>();
        takeLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-take-hint", "Click to enter amount for all"));
        takeMeta.setLore(takeLore);
        takeMass.setItemMeta(takeMeta);
        massInv.setItem(13, takeMass);
        ItemStack setMass = new ItemStack(Material.GOLD_BLOCK);
        ItemMeta setMeta = setMass.getItemMeta();
        setMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.mass-set", "Set Balance for All Selected"));
        ArrayList<String> setLore = new ArrayList<String>();
        setLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-set-hint", "Click to enter amount for all"));
        setMeta.setLore(setLore);
        setMass.setItemMeta(setMeta);
        massInv.setItem(15, setMass);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-return", "Return to Main Menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        massInv.setItem(22, backBtn);
        player.openInventory(massInv);
        this.lastOpenedMenu.put(player.getUniqueId(), "mass");
    }

    private void logTransaction(String uuid, String action, double amount, Player executor) {
        this.transactionHistory.computeIfAbsent(uuid, k -> new ArrayList()).add(new Transaction(System.currentTimeMillis(), action, amount, executor.getName()));
        this.cleanOldTransactions();
        this.plugin.saveTransactions();
    }

    private List<PlayerResult> getFilteredPlayers() {
        ArrayList<PlayerResult> results = new ArrayList<PlayerResult>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            boolean matchesFilter;
            if (player.getName() == null) continue;
            boolean matchesSearch = this.currentSearch.isEmpty() || player.getName().toLowerCase().contains(this.currentSearch.toLowerCase()) || player.getUniqueId().toString().toLowerCase().contains(this.currentSearch.toLowerCase());
            boolean bl = matchesFilter = this.currentFilter == Filter.ALL || this.currentFilter == Filter.ONLINE && player.isOnline() || this.currentFilter == Filter.OFFLINE && !player.isOnline() || this.currentFilter == Filter.SELECTED && this.isSelected(player.getUniqueId().toString());
            if (!matchesSearch || !matchesFilter) continue;
            results.add(new PlayerResult(player.getUniqueId().toString(), player.getName(), player.isOnline(), this.plugin.getEconomy().getBalance(player)));
        }
        results.sort(Comparator.comparingDouble(pr -> pr.balance).reversed());
        return results;
    }

    public void openMainGUI(Player player) {
        this.currentPage = this.lastPage.getOrDefault(player.getUniqueId(), 0);
        this.refreshGUI();
        player.openInventory(this.inventory);
        this.lastOpenedMenu.put(player.getUniqueId(), "main");
        this.playersInGUI.add(player.getUniqueId());
    }

    public void resetSearch(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.currentSearch = "";
        this.currentFilter = Filter.ALL;
        this.currentPage = 0;
        this.selectedPlayers.removeAll(this.playerSelections.getOrDefault(playerUUID, Collections.emptySet()));
        this.playerSelections.remove(playerUUID);
        this.lastPage.put(playerUUID, 0);
        this.lastTarget.remove(playerUUID);
        this.lastOpenedMenu.put(playerUUID, "main");
        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.search-reset", "Search and filters reset."));
        this.openMainGUI(player);
    }

    public void setLastOpenedMenu(UUID playerId, String menu) {
        this.lastOpenedMenu.put(playerId, menu);
    }

    public void setLastTarget(UUID playerId, String target) {
        this.lastTarget.put(playerId, target);
    }

    public PlayerResult getPlayerResultByName(String name) {
        return this.cachedResults.stream().filter(r -> r.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private void requestAmount(Player player, String action, String targetName) {
        PlayerResult result = this.getPlayerResultByName(targetName);
        if (result == null) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-not-found", "Player not found."));
            return;
        }
        player.closeInventory();
        TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount (or click to cancel):"));
        TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
        cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
        message.addExtra((BaseComponent)cancel);
        player.spigot().sendMessage((BaseComponent)message);
        this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.action-cancelled", "Action cancelled."));
                this.openMainGUI(p);
                this.pendingActions.remove(p.getUniqueId());
                this.pendingActionType.remove(p.getUniqueId());
                return;
            }
            try {
                double amount = Double.parseDouble(msg.trim());
                if (amount <= 0.0) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    this.openMainGUI(p);
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                boolean success = false;
                if (action.equals("give")) {
                    success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                    if (success) {
                        this.logTransaction(result.uuid, "give", amount, p);
                    }
                } else if (action.equals("take")) {
                    if (this.plugin.getEconomy().getBalance(target) >= amount) {
                        success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(result.uuid, "take", amount, p);
                        }
                    } else {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.insufficient-funds", "Insufficient funds for %player%", "%player%", target.getName()));
                    }
                }
                if (success) {
                    p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "%action%", action, "%amount%", String.format(this.moneyFormat, amount), "%player%", result.name));
                } else {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                }
                this.openMainGUI(p);
            }
            catch (NumberFormatException e) {
                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                this.openMainGUI(p);
            }
            this.pendingActions.remove(p.getUniqueId());
            this.pendingActionType.remove(p.getUniqueId());
        }));
        this.pendingActionType.put(player.getUniqueId(), action);
        this.pendingActionTarget.put(player.getUniqueId(), result);
    }

    private void requestMassAmount(Player player, String action) {
        player.closeInventory();
        TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount (or click to cancel):"));
        TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
        cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
        message.addExtra((BaseComponent)cancel);
        player.spigot().sendMessage((BaseComponent)message);
        this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.action-cancelled", "Action cancelled."));
                this.openMainGUI(p);
                this.pendingActions.remove(p.getUniqueId());
                this.pendingActionType.remove(p.getUniqueId());
                return;
            }
            try {
                double amount = Double.parseDouble(msg.trim());
                if (amount <= 0.0) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    this.openMainGUI(p);
                    return;
                }
                Set selected = this.playerSelections.getOrDefault(p.getUniqueId(), Collections.emptySet());
                if (selected.isEmpty()) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-players-selected", "No players selected."));
                    this.openMainGUI(p);
                    return;
                }
                int successCount = 0;
                for (UUID uuid : selected) {
                    OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (target.getName() == null) continue;
                    boolean success = false;
                    if (action.equals("mass-give")) {
                        success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(uuid.toString(), "give", amount, p);
                        }
                    } else if (action.equals("mass-take")) {
                        if (this.plugin.getEconomy().getBalance(target) >= amount && (success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess())) {
                            this.logTransaction(uuid.toString(), "take", amount, p);
                        }
                    } else if (action.equals("mass-set")) {
                        double current = this.plugin.getEconomy().getBalance(target);
                        this.plugin.getEconomy().withdrawPlayer(target, current);
                        success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(uuid.toString(), "set", amount, p);
                        }
                    }
                    if (!success) continue;
                    ++successCount;
                }
                String actionName = action.equals("mass-give") ? "gave" : (action.equals("mass-take") ? "took" : "set");
                p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.mass-action-applied", "Applied %action% of $%amount% to %count% players", "%action%", actionName, "%amount%", String.format(this.moneyFormat, amount), "%count%", String.valueOf(successCount)));
                this.openMainGUI(p);
            }
            catch (NumberFormatException e) {
                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                this.openMainGUI(p);
            }
            this.pendingActions.remove(p.getUniqueId());
            this.pendingActionType.remove(p.getUniqueId());
        }));
        this.pendingActionType.put(player.getUniqueId(), action);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof EconomySearchGUI)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String menu = this.lastOpenedMenu.getOrDefault(playerUUID, "main");
        String displayName = clicked.getItemMeta() != null ? clicked.getItemMeta().getDisplayName() : "";
        long now = System.currentTimeMillis();
        if (menu.equals("main")) {
            int slot = event.getSlot();
            if ((slot == 45 || slot == 53) && now - this.lastPageSwitch.getOrDefault(playerUUID, 0L) < 1000L) {
                return;
            }
            if (slot == 45 && this.currentPage > 0) {
                this.lastPageSwitch.put(playerUUID, now);
                this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.max(0, this.currentPage - 5) : --this.currentPage;
                this.lastPage.put(playerUUID, this.currentPage);
                this.refreshGUI();
            } else if (slot == 53 && (this.currentPage + 1) * 36 < this.cachedResults.size()) {
                this.lastPageSwitch.put(playerUUID, now);
                if (event.getClick() == ClickType.SHIFT_RIGHT) {
                    int totalPages = this.cachedResults.size() / 36 + (this.cachedResults.size() % 36 > 0 ? 1 : 0);
                    this.currentPage = Math.min(totalPages - 1, this.currentPage + 5);
                } else {
                    ++this.currentPage;
                }
                this.lastPage.put(playerUUID, this.currentPage);
                this.refreshGUI();
            } else if (slot == 46) {
                for (PlayerResult result : this.cachedResults.subList(this.currentPage * 36, Math.min((this.currentPage + 1) * 36, this.cachedResults.size()))) {
                    UUID uuid = UUID.fromString(result.uuid);
                    this.selectedPlayers.add(uuid);
                    this.playerSelections.computeIfAbsent(playerUUID, k -> new HashSet()).add(uuid);
                }
                this.refreshGUI();
            } else if (slot == 47) {
                Set selections = this.playerSelections.getOrDefault(playerUUID, Collections.emptySet());
                this.selectedPlayers.removeAll(selections);
                this.playerSelections.remove(playerUUID);
                this.refreshGUI();
            } else if (slot == 48) {
                Set selected = this.playerSelections.getOrDefault(playerUUID, Collections.emptySet());
                if (selected.isEmpty()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-players-selected", "No players selected."));
                    return;
                }
                this.openMassActionsMenu(player);
            } else if (slot == 4) {
                if (event.getClick() == ClickType.RIGHT) {
                    this.resetSearch(player);
                } else if (event.getClick() == ClickType.LEFT) {
                    player.closeInventory();
                    TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-search", "Enter name or UUID to search: "));
                    TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                    cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                    message.addExtra((BaseComponent)cancel);
                    player.spigot().sendMessage((BaseComponent)message);
                    this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        String input = ChatColor.stripColor((String)msg.trim());
                        if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                            this.resetSearch(p);
                            return;
                        }
                        this.currentSearch = input;
                        this.currentPage = 0;
                        this.lastPage.put(p.getUniqueId(), 0);
                        this.cachedResults.clear();
                        p.openInventory(this.inventory);
                        this.playersInGUI.add(p.getUniqueId());
                        this.lastOpenedMenu.put(p.getUniqueId(), "main");
                        this.cachedResults = this.getFilteredPlayers();
                        this.setupMainMenuLayout();
                        p.updateInventory();
                        this.pendingActions.remove(p.getUniqueId());
                    }));
                }
            } else if (slot == 49) {
                this.applyFilter(Filter.ALL, player);
            } else if (slot == 50) {
                this.applyFilter(Filter.ONLINE, player);
            } else if (slot == 51) {
                this.applyFilter(Filter.OFFLINE, player);
            } else if (slot >= 9 && slot <= 44) {
                String name = ChatColor.stripColor((String)displayName);
                PlayerResult result = this.cachedResults.stream().filter(r -> r.name.equalsIgnoreCase(name)).findFirst().orElse(null);
                if (result == null) {
                    return;
                }
                if (event.getClick() == ClickType.LEFT) {
                    this.openPlayerFinanceManagement(player, result);
                } else if (event.getClick() == ClickType.RIGHT) {
                    this.openContextMenu(player, name);
                } else if (event.getClick() == ClickType.SHIFT_LEFT && now - this.lastPageSwitch.getOrDefault(playerUUID, 0L) >= 1000L) {
                    this.lastPageSwitch.put(playerUUID, now);
                    UUID uuid = UUID.fromString(result.uuid);
                    Set selections = this.playerSelections.computeIfAbsent(playerUUID, k -> new HashSet());
                    if (this.selectedPlayers.contains(uuid)) {
                        this.selectedPlayers.remove(uuid);
                        selections.remove(uuid);
                    } else {
                        this.selectedPlayers.add(uuid);
                        selections.add(uuid);
                    }
                    this.refreshGUI();
                }
            }
        } else if (menu.equals("finance")) {
            int slot = event.getSlot();
            String targetName = this.lastTarget.get(playerUUID);
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result == null) {
                return;
            }
            if (slot == 13) {
                player.closeInventory();
                if (player.hasPermission("economygui.give")) {
                    TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount in chat (or 'cancel' to abort):"));
                    TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                    cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                    message.addExtra((BaseComponent)cancel);
                    player.spigot().sendMessage((BaseComponent)message);
                    this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                            p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                            this.openPlayerFinanceManagement(p, result);
                            this.pendingActions.remove(p.getUniqueId());
                            return;
                        }
                        try {
                            double amount = Double.parseDouble(msg.trim());
                            if (amount <= 0.0) {
                                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                                this.openPlayerFinanceManagement(p, result);
                                return;
                            }
                            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                            if (this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) {
                                p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.gave-amount", "Gave $%amount% to %player%", "%amount%", String.format(this.moneyFormat, amount), "%player%", result.name));
                                this.logTransaction(result.uuid, "give", amount, p);
                            } else {
                                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                            }
                        }
                        catch (NumberFormatException e) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                        }
                        this.openPlayerFinanceManagement(p, result);
                        this.pendingActions.remove(p.getUniqueId());
                    }));
                } else {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("messages.no-permission-give", "You don't have permission to give."));
                    this.openPlayerFinanceManagement(player, result);
                }
            } else if (slot == 20) {
                this.openDigitalMenu(player, this.plugin.getMessage("action.give", "Give"), result);
            } else if (slot == 22) {
                this.openDigitalMenu(player, this.plugin.getMessage("action.take", "Take"), result);
            } else if (slot == 24) {
                player.closeInventory();
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount in chat (or 'cancel' to abort):"));
                TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                        p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                        this.openPlayerFinanceManagement(p, result);
                        this.pendingActions.remove(p.getUniqueId());
                        return;
                    }
                    try {
                        double amount = Double.parseDouble(msg.trim());
                        if (amount < 0.0) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.negative-amount", "Amount cannot be negative."));
                            this.openPlayerFinanceManagement(p, result);
                            return;
                        }
                        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                        double current = this.plugin.getEconomy().getBalance(target);
                        if (this.plugin.getEconomy().withdrawPlayer(target, current).transactionSuccess() && this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) {
                            p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.set-amount", "Set balance to $%amount% for %player%", "%amount%", String.format(this.moneyFormat, amount), "%player%", result.name));
                            this.logTransaction(result.uuid, "set", amount, p);
                        } else {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                        }
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                    }
                    this.openPlayerFinanceManagement(p, result);
                    this.pendingActions.remove(p.getUniqueId());
                }));
            } else if (slot == 31) {
                this.openHistoryMenu(player, result);
            } else if (slot == 49) {
                this.openMainGUI(player);
            }
        } else if (menu.equals("context")) {
            String targetName = this.lastTarget.getOrDefault(player.getUniqueId(), "");
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result == null) {
                this.openMainGUI(player);
                this.lastOpenedMenu.put(player.getUniqueId(), "main");
                return;
            }
            if (event.getSlot() == 4 && this.plugin.isFullManagementEnabled()) {
                this.openPlayerFinanceManagement(player, result);
                this.lastOpenedMenu.put(player.getUniqueId(), "finance");
            } else if (event.getSlot() >= 10 && event.getSlot() <= 15 && this.plugin.isQuickActionsEnabled()) {
                if (event.getSlot() == 10) {
                    this.executeQuickAction(player, "give", 100.0);
                } else if (event.getSlot() == 11) {
                    this.executeQuickAction(player, "give", 1000.0);
                } else if (event.getSlot() == 12) {
                    this.executeQuickAction(player, "take", 100.0);
                } else if (event.getSlot() == 13) {
                    this.executeQuickAction(player, "take", 1000.0);
                } else if (event.getSlot() == 14) {
                    this.executeQuickAction(player, "set", 5000.0);
                } else if (event.getSlot() == 15) {
                    this.executeQuickAction(player, "set", 0.0);
                }
            } else if (event.getSlot() == 16 && this.plugin.isQuickActionsEnabled()) {
                this.requestAmount(player, "custom", result.toString());
            } else if (event.getSlot() == 22) {
                this.openMainGUI(player);
                this.lastOpenedMenu.put(player.getUniqueId(), "main");
            }
        } else if (menu.equals("digital")) {
            int slotClicked = event.getSlot();
            PlayerResult result = this.pendingActionTarget.get(playerUUID);
            if (result == null) {
                return;
            }
            if (slotClicked == 16) {
                double amount = this.pendingActionAmount.getOrDefault(playerUUID, 0.0);
                String action = this.pendingActionType.getOrDefault(playerUUID, this.plugin.getMessage("action.give", "Give"));
                if (amount <= 0.0) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                boolean success = false;
                if (action.equals(this.plugin.getMessage("action.give", "Give"))) {
                    success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                    if (success) {
                        this.logTransaction(result.uuid, "give", amount, player);
                    }
                } else if (action.equals(this.plugin.getMessage("action.take", "Take"))) {
                    if (this.plugin.getEconomy().getBalance(target) >= amount) {
                        success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(result.uuid, "take", amount, player);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.insufficient-funds", "Insufficient funds for %player%", "player", target.getName()));
                    }
                }
                if (success) {
                    player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "action", action, "amount", String.format(this.moneyFormat, amount), "player", result.name));
                } else {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                }
                this.pendingActionAmount.put(playerUUID, 0.0);
                this.refreshGUI();
                this.openPlayerFinanceManagement(player, result);
            } else if (slotClicked == 18) {
                this.pendingActionAmount.put(playerUUID, 0.0);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", "0"));
                this.openDigitalMenu(player, this.pendingActionType.get(playerUUID), result);
            } else if (slotClicked == 26) {
                this.openPlayerFinanceManagement(player, result);
            } else if (slotClicked >= 9 && slotClicked <= 14) {
                int[] amounts = new int[]{1, 5, 10, 100, 1000, 5000};
                int index = slotClicked - 9;
                if (index >= 0 && index < amounts.length) {
                    double currentAmount = this.pendingActionAmount.getOrDefault(playerUUID, 0.0);
                    this.pendingActionAmount.put(playerUUID, currentAmount + (double)amounts[index]);
                    player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", String.valueOf(amounts[index])));
                    this.openDigitalMenu(player, this.pendingActionType.get(playerUUID), result);
                }
            } else if (slotClicked == 22) {
                player.closeInventory();
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-custom", "Enter custom amount: "));
                TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String input = ChatColor.stripColor((String)msg.trim());
                    if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                        p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                        this.pendingActions.remove(p.getUniqueId());
                        return;
                    }
                    try {
                        double amount = Double.parseDouble(input);
                        if (amount <= 0.0) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                            this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                            return;
                        }
                        double currentAmount = this.pendingActionAmount.getOrDefault(p.getUniqueId(), 0.0);
                        this.pendingActionAmount.put(p.getUniqueId(), currentAmount + amount);
                        p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", String.valueOf(amount)));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                    }
                    this.pendingActions.remove(p.getUniqueId());
                }));
            }
        } else if (menu.equals("history")) {
            if (event.getSlot() == 49) {
                PlayerResult result = this.getPlayerResultByName(this.lastTarget.get(player.getUniqueId()));
                if (result != null) {
                    if (!this.plugin.isFullManagementEnabled()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.full-management-disabled", "Full management is disabled in config!"));
                        this.openMainGUI(player);
                        this.lastOpenedMenu.put(player.getUniqueId(), "main");
                    } else {
                        this.openPlayerFinanceManagement(player, result);
                        this.lastOpenedMenu.put(player.getUniqueId(), "finance");
                    }
                }
            } else if (event.getSlot() == 45) {
                int page = this.lastPage.getOrDefault(player.getUniqueId(), 0);
                if (page > 0) {
                    this.lastPage.put(player.getUniqueId(), page - 1);
                    this.openHistoryMenu(player, this.getPlayerResultByName(this.lastTarget.get(player.getUniqueId())));
                }
            } else if (event.getSlot() == 53) {
                List history;
                int totalPages;
                int page = this.lastPage.getOrDefault(player.getUniqueId(), 0);
                PlayerResult result = this.getPlayerResultByName(this.lastTarget.get(player.getUniqueId()));
                if (result != null && page < (totalPages = (history = (List)this.transactionHistory.getOrDefault(result.uuid, new ArrayList())).size() / 45 + (history.size() % 45 > 0 ? 1 : 0)) - 1) {
                    this.lastPage.put(player.getUniqueId(), page + 1);
                    this.openHistoryMenu(player, result);
                }
            }
        } else if (menu.equals("mass")) {
            int slot = event.getSlot();
            if (slot == 11) {
                this.requestMassAmount(player, "mass-give");
            } else if (slot == 13) {
                this.requestMassAmount(player, "mass-take");
            } else if (slot == 15) {
                this.requestMassAmount(player, "mass-set");
            } else if (slot == 22) {
                this.openMainGUI(player);
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.pendingActions.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            String message = event.getMessage();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                ChatAction action = this.pendingActions.get(player.getUniqueId());
                if (action == null) {
                    return;
                }
                if (message.equalsIgnoreCase("cancel") || message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                    player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                    this.pendingActions.remove(player.getUniqueId());
                    this.openLastGUIMenu(player);
                    return;
                }
                if (this.pendingActionType.get(player.getUniqueId()) != null && this.pendingActionType.get(player.getUniqueId()).startsWith("mass-")) {
                    String actionType = this.pendingActionType.get(player.getUniqueId());
                    try {
                        double amount = Double.parseDouble(message.trim());
                        if (actionType.equals("mass-set") && amount < 0.0 || !actionType.equals("mass-set") && amount <= 0.0) {
                            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                            this.openMassActionsMenu(player);
                            return;
                        }
                        int count = 0;
                        for (UUID uuid : this.selectedPlayers) {
                            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)uuid);
                            if (actionType.equals("mass-give")) {
                                if (!this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) continue;
                                ++count;
                                this.logTransaction(uuid.toString(), "give", amount, player);
                                continue;
                            }
                            if (actionType.equals("mass-take")) {
                                if (!(this.plugin.getEconomy().getBalance(target) >= amount) || !this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess()) continue;
                                ++count;
                                this.logTransaction(uuid.toString(), "take", amount, player);
                                continue;
                            }
                            if (!actionType.equals("mass-set") || !this.plugin.getEconomy().withdrawPlayer(target, this.plugin.getEconomy().getBalance(target)).transactionSuccess() || !this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) continue;
                            ++count;
                            this.logTransaction(uuid.toString(), "set", amount, player);
                        }
                        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.mass-action-applied", "Applied %action% on $%amount% to %count% players", "action", actionType.replace("mass-", ""), "amount", String.format(this.moneyFormat, amount), "count", String.valueOf(count)));
                        this.openMassActionsMenu(player);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                        this.openMassActionsMenu(player);
                    }
                    this.pendingActions.remove(player.getUniqueId());
                    this.pendingActionType.remove(player.getUniqueId());
                    return;
                }
                action.execute(message, player);
            });
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof EconomySearchGUI) {
            this.playersInGUI.remove(event.getPlayer().getUniqueId());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeQuickAction(Player player, String action, double amount) {
        PlayerResult result = this.getPlayerResultByName(this.lastTarget.get(player.getUniqueId()));
        if (result == null) {
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
        Economy econ = this.plugin.getEconomy();
        boolean success = false;
        if (action.equals("give")) {
            success = econ.depositPlayer(target, amount).transactionSuccess();
        } else if (action.equals("take")) {
            if (!(econ.getBalance(target) >= amount)) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.insufficient-funds", "Insufficient funds for %player%", "player", result.name));
                return;
            }
            success = econ.withdrawPlayer(target, amount).transactionSuccess();
        } else if (action.equals("set")) {
            boolean bl = success = econ.withdrawPlayer(target, econ.getBalance(target)).transactionSuccess() && econ.depositPlayer(target, amount).transactionSuccess();
        }
        if (success) {
            this.logTransaction(result.uuid, action, amount, player);
            player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "action", action, "amount", String.format(this.moneyFormat, amount), "player", result.name));
        } else {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
        }
        this.openContextMenu(player, result.name);
    }

    public void loadTransactionHistory(FileConfiguration config) {
        this.transactionHistory.clear();
        for (String uuid : config.getKeys(false)) {
            ArrayList<Transaction> list = new ArrayList<Transaction>();
            List rawList = config.getStringList(uuid);
            for (String raw : rawList) {
                String[] parts = raw.split(";");
                if (parts.length != 4) continue;
                try {
                    long ts = Long.parseLong(parts[0]);
                    String action = parts[1];
                    double amt = Double.parseDouble(parts[2]);
                    String exec = parts[3];
                    list.add(new Transaction(ts, action, amt, exec));
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid transaction format for UUID " + uuid + ": " + raw);
                }
            }
            this.transactionHistory.put(uuid, list);
        }
        this.cleanOldTransactions();
    }

    public void saveTransactionHistory(FileConfiguration config) {
        this.cleanOldTransactions();
        HashSet currentKeys = new HashSet(config.getKeys(false));
        for (String string : currentKeys) {
            if (this.transactionHistory.containsKey(string)) continue;
            config.set(string, null);
        }
        for (Map.Entry entry : this.transactionHistory.entrySet()) {
            List rawList = ((List)entry.getValue()).stream().map(t -> t.timestamp + ";" + t.action + ";" + t.amount + ";" + t.executor).collect(Collectors.toList());
            config.set((String)entry.getKey(), rawList);
        }
    }

    public void cleanOldTransactions() {
        if (this.plugin.transactionRetentionDays <= 0) {
            return;
        }
        long cutoff = System.currentTimeMillis() - (long)this.plugin.transactionRetentionDays * 86400000L;
        for (List<Transaction> list : this.transactionHistory.values()) {
            list.removeIf(t -> t.timestamp < cutoff);
        }
        this.transactionHistory.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
    }

    public void openLastGUIMenu(Player player) {
        String lastMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "main");
        this.currentPage = this.lastPage.getOrDefault(player.getUniqueId(), 0);
        this.playersInGUI.add(player.getUniqueId());
        if (lastMenu.equals("main")) {
            this.openMainGUI(player);
        } else if (lastMenu.equals("finance")) {
            String targetName = this.lastTarget.getOrDefault(player.getUniqueId(), "");
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result != null) {
                this.openPlayerFinanceManagement(player, result);
            } else {
                this.openMainGUI(player);
            }
        } else if (lastMenu.equals("context")) {
            String targetName = this.lastTarget.getOrDefault(player.getUniqueId(), "");
            if (!targetName.isEmpty()) {
                this.openContextMenu(player, targetName);
            } else {
                this.openMainGUI(player);
            }
        } else if (lastMenu.equals("digital")) {
            PlayerResult result = this.pendingActionTarget.get(player.getUniqueId());
            String action = this.pendingActionType.get(player.getUniqueId());
            if (result != null && action != null) {
                this.openDigitalMenu(player, action, result);
            } else {
                this.openMainGUI(player);
            }
        } else if (lastMenu.equals("history")) {
            String targetName = this.lastTarget.getOrDefault(player.getUniqueId(), "");
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result != null) {
                this.openHistoryMenu(player, result);
            } else {
                this.openMainGUI(player);
            }
        } else if (lastMenu.equals("mass")) {
            this.openMassActionsMenu(player);
        }
    }

    public void refreshOpenGUIs() {
        for (UUID uuid : this.playersInGUI) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            this.openLastGUIMenu(player);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static enum Filter {
        ALL,
        ONLINE,
        OFFLINE,
        SELECTED;

    }

    private static class PlayerResult {
        String uuid;
        String name;
        boolean online;
        double balance;

        PlayerResult(String uuid, String name, boolean online, double balance) {
            this.uuid = uuid;
            this.name = name;
            this.online = online;
            this.balance = balance;
        }
    }

    private static class Transaction {
        long timestamp;
        String action;
        double amount;
        String executor;

        Transaction(long timestamp, String action, double amount, String executor) {
            this.timestamp = timestamp;
            this.action = action;
            this.amount = amount;
            this.executor = executor;
        }
    }

    @FunctionalInterface
    static interface ChatAction {
        public void execute(String var1, Player var2);
    }
}

