/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.economyGUI;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import ru.stepanyaa.economyGUI.EconomySearchGUI;

public class EconomyGUI
extends JavaPlugin
implements CommandExecutor,
TabCompleter {
    private Economy econ = null;
    private FileConfiguration messagesConfig;
    private FileConfiguration transactionsConfig;
    private File transactionsFile;
    private String language;
    private static final String CURRENT_VERSION = "1.0.1";
    private EconomySearchGUI economySearchGUI;
    private final Set<String> adminUUIDs = ConcurrentHashMap.newKeySet();
    public int transactionRetentionDays;
    private boolean playerSelectionEnabled;
    private boolean massOperationsEnabled;
    private boolean quickActionsEnabled;
    private boolean fullManagementEnabled;

    public void onEnable() {
        PluginCommand command;
        if (!this.setupEconomy()) {
            this.getLogger().severe(this.getMessage("warning.no-economy", "Economy provider not found! Disabling plugin."));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.transactionRetentionDays = this.getConfig().getInt("features.transaction-retention-days", 30);
        this.playerSelectionEnabled = this.getConfig().getBoolean("features.player-selection", true);
        this.massOperationsEnabled = this.getConfig().getBoolean("features.mass-operations", true);
        this.quickActionsEnabled = this.getConfig().getBoolean("features.quick-actions", true);
        this.fullManagementEnabled = this.getConfig().getBoolean("features.full-management", true);
        this.economySearchGUI = new EconomySearchGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.economySearchGUI, (Plugin)this);
        this.loadMessages();
        if (this.messagesConfig == null) {
            this.getLogger().severe("Failed to load messages configuration. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadTransactions();
        if (!(this.playerSelectionEnabled || this.massOperationsEnabled || this.quickActionsEnabled || this.fullManagementEnabled)) {
            this.getLogger().warning(this.getMessage("error.all-features-disabled", "All features are disabled in config! Commands will be limited."));
        }
        if ((command = this.getCommand("economygui")) != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setPermissionMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
        } else {
            this.getLogger().warning("Failed to register command 'economygui'!");
        }
        this.adminUUIDs.addAll(this.getConfig().getStringList("admin-uuids"));
        this.getLogger().info(this.getMessage("warning.plugin-enabled", "EconomyGUI enabled with language: %lang%", "lang", this.language));
    }

    public void onDisable() {
        if (this.economySearchGUI != null) {
            this.saveTransactions();
        }
        this.getLogger().info("EconomyGUI disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    private void loadMessages() {
        String lang = this.language != null && (this.language.equals("en") || this.language.equals("ru")) ? this.language : "en";
        File messagesFile = new File(this.getDataFolder(), "messages_" + lang + ".yml");
        try {
            if (!messagesFile.exists()) {
                if (this.getResource("messages_" + lang + ".yml") == null) {
                    this.getLogger().severe("Resource messages_" + lang + ".yml not found in JAR!");
                    this.messagesConfig = new YamlConfiguration();
                    return;
                }
                this.saveResource("messages_" + lang + ".yml", false);
                this.getLogger().info("Created messages file: messages_" + lang + ".yml");
            }
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
            if (this.messagesConfig.getKeys(false).isEmpty()) {
                this.getLogger().warning("Messages file messages_" + lang + ".yml is empty!");
            } else {
                this.getLogger().info("Loaded messages file: messages_" + lang + ".yml with " + this.messagesConfig.getKeys(true).size() + " keys");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load or create messages_" + lang + ".yml: " + e.getMessage());
            this.messagesConfig = new YamlConfiguration();
        }
    }

    private void loadTransactions() {
        this.transactionsFile = new File(this.getDataFolder(), "transactions/transactions.yml");
        if (!this.transactionsFile.exists()) {
            try {
                this.transactionsFile.createNewFile();
                this.getLogger().info("Created transactions file: transactions.yml");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create transactions.yml: " + e.getMessage());
            }
        }
        this.transactionsConfig = YamlConfiguration.loadConfiguration((File)this.transactionsFile);
        this.economySearchGUI.loadTransactionHistory(this.transactionsConfig);
    }

    public void saveTransactions() {
        this.economySearchGUI.saveTransactionHistory(this.transactionsConfig);
        try {
            this.transactionsConfig.save(this.transactionsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save transactions.yml: " + e.getMessage());
        }
    }

    public String getMessage(String key) {
        if (this.messagesConfig == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)key);
        }
        String msg = this.messagesConfig.getString(key, key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getMessage(String key, String def) {
        if (this.messagesConfig == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)def);
        }
        String msg = this.messagesConfig.getString(key, def);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getMessage(String key, String def, Object ... placeholders) {
        String msg = this.getMessage(key, def);
        if (placeholders != null && placeholders.length >= 2 && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                String placeholder = placeholders[i].toString();
                String value = placeholders[i + 1].toString();
                msg = msg.replace("%" + placeholder + "%", value);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.player-only", "This command is for players only!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("economygui.admin") && !player.hasPermission("economygui.gui")) {
            player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("gui")) {
            if (args.length > 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage-gui", "Usage: /economygui gui"));
                return true;
            }
            this.economySearchGUI.openLastGUIMenu(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("economygui.reload")) {
                player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage-reload", "Usage: /economygui reload"));
                return true;
            }
            this.reloadPlugin(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reset")) {
            if (!player.hasPermission("economygui.reset")) {
                player.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /economygui reset"));
                return true;
            }
            this.economySearchGUI.resetSearch(player);
            return true;
        }
        player.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /economygui <gui | reload | reset>"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("gui", "reload", "reset").stream().filter(cmd -> sender.hasPermission("economygui." + cmd) || sender.hasPermission("economygui.admin")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void reloadPlugin(Player player) {
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.loadMessages();
        this.loadTransactions();
        this.playerSelectionEnabled = this.getConfig().getBoolean("features.player-selection", true);
        this.massOperationsEnabled = this.getConfig().getBoolean("features.mass-operations", true);
        this.quickActionsEnabled = this.getConfig().getBoolean("features.quick-actions", true);
        this.fullManagementEnabled = this.getConfig().getBoolean("features.full-management", true);
        this.economySearchGUI.refreshOpenGUIs();
        player.sendMessage(ChatColor.GREEN + this.getMessage("action.config-reloaded", "Configuration reloaded."));
    }

    public boolean isPlayerSelectionEnabled() {
        return this.playerSelectionEnabled;
    }

    public boolean isMassOperationsEnabled() {
        return this.massOperationsEnabled;
    }

    public boolean isQuickActionsEnabled() {
        return this.quickActionsEnabled;
    }

    public boolean isFullManagementEnabled() {
        return this.fullManagementEnabled;
    }

    public Set<String> getAdminUUIDs() {
        return this.adminUUIDs;
    }
}

