/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.economyGUI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import ru.stepanyaa.economyGUI.EconomyGUI;

public class EconomySearchGUI
implements Listener,
InventoryHolder {
    private static final long PAGE_SWITCH_COOLDOWN = 1000L;
    private final EconomyGUI plugin;
    private Inventory inventory;
    private int currentPage = 0;
    private String currentSearch = "";
    private Filter currentFilter = Filter.ALL;
    private final Set<UUID> selectedPlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Set<UUID>> playerSelections = new ConcurrentHashMap<UUID, Set<UUID>>();
    private final Map<UUID, String> lastOpenedMenu = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Integer> lastPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, String> lastTarget = new ConcurrentHashMap<UUID, String>();
    private final Set<UUID> playersInGUI = ConcurrentHashMap.newKeySet();
    private final Map<UUID, ChatAction> pendingActions = new ConcurrentHashMap<UUID, ChatAction>();
    private final Map<UUID, String> pendingActionType = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Double> pendingActionAmount = new ConcurrentHashMap<UUID, Double>();
    private final Map<UUID, PlayerResult> pendingActionTarget = new ConcurrentHashMap<UUID, PlayerResult>();
    private List<PlayerResult> cachedResults = new ArrayList<PlayerResult>();
    private final Map<String, List<String>> transactionHistory = new ConcurrentHashMap<String, List<String>>();
    private String moneyFormat;
    private boolean usePlaceholderAPI;
    private final String[] skinNames = new String[]{"Notch", "jeb_", "Dinnerbone", "Herobrine"};
    private final Map<UUID, Long> lastPageSwitch = new ConcurrentHashMap<UUID, Long>();

    public EconomySearchGUI(EconomyGUI plugin) {
        this.plugin = plugin;
        this.usePlaceholderAPI = plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.moneyFormat = "%,.2f";
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_PURPLE + plugin.getMessage("gui.title", "Economy Management")));
        this.refreshGUI();
    }

    private void refreshGUI() {
        this.setupMainMenuLayout();
    }

    private void setupMainMenuLayout() {
        this.inventory.clear();
        for (int slot = 0; slot < 9; ++slot) {
            this.inventory.setItem(slot, new ItemStack(Material.AIR));
        }
        ItemStack searchItem = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = searchItem.getItemMeta();
        searchMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.search", "Search: %search_query%", "search_query", this.currentSearch.isEmpty() ? this.plugin.getMessage("gui.search-all", "all") : this.currentSearch));
        ArrayList<String> searchLore = new ArrayList<String>();
        searchLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.search-hint", "Left click: Enter query | Right click: Reset search | Shift+Left: Select/Deselect"));
        searchMeta.setLore(searchLore);
        searchItem.setItemMeta(searchMeta);
        this.inventory.setItem(4, searchItem);
        this.inventory.setItem(49, this.createFilterItem(Filter.ALL));
        this.inventory.setItem(50, this.createFilterItem(Filter.ONLINE));
        this.inventory.setItem(51, this.createFilterItem(Filter.OFFLINE));
        if (this.plugin.isMassOperationsEnabled()) {
            ItemStack massItem = new ItemStack(Material.DIAMOND_BLOCK);
            ItemMeta massMeta = massItem.getItemMeta();
            massMeta.setDisplayName(ChatColor.AQUA + this.plugin.getMessage("gui.mass-menu-title", "Mass Operations"));
            ArrayList<String> massLore = new ArrayList<String>();
            massLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-hint", "Click for mass give/take/set (select players first)"));
            massMeta.setLore(massLore);
            massItem.setItemMeta(massMeta);
            this.inventory.setItem(48, massItem);
        }
        int totalPages = this.cachedResults.size() / 36 + (this.cachedResults.size() % 36 > 0 ? 1 : 0);
        int currentPageNum = this.currentPage + 1;
        ItemStack prev = this.currentPage > 0 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta prevMeta = prev.getItemMeta();
        prevMeta.setDisplayName(this.currentPage > 0 ? ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> prevLore = new ArrayList<String>();
        prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(currentPageNum), "total_pages", String.valueOf(totalPages)));
        if (this.currentPage > 0) {
            prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
        }
        prevMeta.setLore(prevLore);
        prev.setItemMeta(prevMeta);
        this.inventory.setItem(45, prev);
        ItemStack next = this.currentPage < totalPages - 1 ? new ItemStack(Material.ARROW) : new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta nextMeta = next.getItemMeta();
        nextMeta.setDisplayName(this.currentPage < totalPages - 1 ? ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next Page") : ChatColor.RED + this.plugin.getMessage("gui.no-page", "No Page"));
        ArrayList<String> nextLore = new ArrayList<String>();
        nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.page-info", "Page %current_page% of %total_pages%", "current_page", String.valueOf(currentPageNum), "total_pages", String.valueOf(totalPages)));
        if (this.currentPage < totalPages - 1) {
            nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
        }
        nextMeta.setLore(nextLore);
        next.setItemMeta(nextMeta);
        this.inventory.setItem(53, next);
        if (this.plugin.isPlayerSelectionEnabled()) {
            ItemStack selectBtn = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta selectMeta = selectBtn.getItemMeta();
            selectMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.select-all", "Select All"));
            ArrayList<String> selectLore = new ArrayList<String>();
            selectLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-select", "Click to select all on page"));
            selectMeta.setLore(selectLore);
            selectBtn.setItemMeta(selectMeta);
            this.inventory.setItem(46, selectBtn);
            ItemStack cancelBtn = new ItemStack(Material.REDSTONE_BLOCK);
            ItemMeta cancelMeta = cancelBtn.getItemMeta();
            cancelMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.cancel-selection", "Cancel Selection"));
            ArrayList<String> cancelLore = new ArrayList<String>();
            cancelLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-cancel", "Click to cancel all selections"));
            cancelMeta.setLore(cancelLore);
            cancelBtn.setItemMeta(cancelMeta);
            this.inventory.setItem(47, cancelBtn);
        }
        List<PlayerResult> results = this.getFilteredPlayers();
        this.cachedResults = results;
        int start = this.currentPage * 36;
        int end = Math.min(start + 36, results.size());
        for (int i = start; i < end; ++i) {
            PlayerResult result = results.get(i);
            OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
            ItemStack head = this.createPlayerHead(offPlayer, i);
            int slot = 9 + (i - start);
            this.inventory.setItem(slot, head);
        }
        if (results.isEmpty()) {
            ItemStack noPlayers = new ItemStack(Material.BARRIER);
            ItemMeta meta = noPlayers.getItemMeta();
            meta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-players", "No players found"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.no-players-hint", "Try changing the search or filter"));
            meta.setLore(lore);
            noPlayers.setItemMeta(meta);
            this.inventory.setItem(22, noPlayers);
        }
    }

    private ItemStack createFilterItem(Filter filter) {
        String displayName;
        Material mat;
        switch (filter.ordinal()) {
            case 0: {
                mat = Material.COMPASS;
                break;
            }
            case 1: {
                mat = Material.LIME_DYE;
                break;
            }
            case 2: {
                mat = Material.GRAY_DYE;
                break;
            }
            default: {
                mat = Material.PAPER;
            }
        }
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        switch (filter.ordinal()) {
            case 0: {
                displayName = ChatColor.WHITE + this.plugin.getMessage("filter.all", "All Players");
                break;
            }
            case 1: {
                displayName = ChatColor.GREEN + this.plugin.getMessage("filter.online", "Online Players");
                break;
            }
            case 2: {
                displayName = ChatColor.GRAY + this.plugin.getMessage("filter.offline", "Offline Players");
                break;
            }
            default: {
                displayName = ChatColor.GRAY + "Unknown";
            }
        }
        meta.setDisplayName(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + this.plugin.getMessage("filter.filter-hint", "Click to apply filter"));
        if (this.currentFilter == filter) {
            lore.add(ChatColor.GREEN + this.plugin.getMessage("filter.filter-active", "\u2713 Active filter"));
            meta.addEnchant(this.getGlowEnchantment(), 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPlayerHead(OfflinePlayer player, int index) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(player);
        meta.setDisplayName(ChatColor.YELLOW + player.getName());
        ArrayList<String> lore = new ArrayList<String>();
        double balance = this.plugin.getEconomy().getBalance(player);
        String formattedBalance = String.format(this.moneyFormat, balance);
        lore.add(ChatColor.GOLD + this.plugin.getMessage("gui.balance", "Balance: $%balance%", "balance", formattedBalance));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions", "Left click: Manage | Right click: Quick Actions | Shift+Left: Select"));
        if (this.isSelected(player.getUniqueId().toString())) {
            lore.add(ChatColor.GREEN + this.plugin.getMessage("gui.selected", "Selected"));
            meta.addEnchant(this.getGlowEnchantment(), 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.setLore(lore);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private Enchantment getGlowEnchantment() {
        String version = Bukkit.getBukkitVersion();
        return version.contains("1.16") ? Enchantment.DURABILITY : Enchantment.VANISHING_CURSE;
    }

    private boolean isSelected(String uuid) {
        return this.selectedPlayers.contains(UUID.fromString(uuid));
    }

    private void applyFilter(Filter newFilter, Player player) {
        this.currentFilter = newFilter;
        this.currentPage = 0;
        this.lastPage.put(player.getUniqueId(), 0);
        this.refreshGUI();
        player.sendMessage(ChatColor.GREEN + "\u041f\u0440\u0438\u043c\u0435\u043d\u0451\u043d \u0444\u0438\u043b\u044c\u0442\u0440: " + newFilter.name());
    }

    private void openPlayerFinanceManagement(Player player, PlayerResult result) {
        Inventory financeInv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.title", "Economy Management") + ": " + result.name));
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
        financeInv.setItem(4, this.createPlayerHead(target, 0));
        ItemStack inputField = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta inputMeta = inputField.getItemMeta();
        inputMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter Amount"));
        ArrayList<String> inputLore = new ArrayList<String>();
        inputLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-amount-hint", "Left click to enter amount in chat"));
        inputMeta.setLore(inputLore);
        inputField.setItemMeta(inputMeta);
        financeInv.setItem(13, inputField);
        ItemStack giveBtn = new ItemStack(Material.EMERALD);
        ItemMeta giveMeta = giveBtn.getItemMeta();
        giveMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("action.give", "Give Amount"));
        ArrayList<String> giveLore = new ArrayList<String>();
        giveLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.give-hint", "Click to open digital menu"));
        giveMeta.setLore(giveLore);
        giveBtn.setItemMeta(giveMeta);
        financeInv.setItem(20, giveBtn);
        ItemStack takeBtn = new ItemStack(Material.REDSTONE);
        ItemMeta takeMeta = takeBtn.getItemMeta();
        takeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("action.take", "Take Amount"));
        ArrayList<String> takeLore = new ArrayList<String>();
        takeLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.take-hint", "Click to open digital menu"));
        takeMeta.setLore(takeLore);
        takeBtn.setItemMeta(takeMeta);
        financeInv.setItem(22, takeBtn);
        ItemStack setBtn = new ItemStack(Material.GOLD_INGOT);
        ItemMeta setMeta = setBtn.getItemMeta();
        setMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("action.set", "Set Amount"));
        ArrayList<String> setLore = new ArrayList<String>();
        setLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.set-hint", "Click to enter amount in chat"));
        setMeta.setLore(setLore);
        setBtn.setItemMeta(setMeta);
        financeInv.setItem(24, setBtn);
        ItemStack historyBtn = new ItemStack(Material.BOOK);
        ItemMeta historyMeta = historyBtn.getItemMeta();
        historyMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("history.operations", "Operations History"));
        ArrayList<String> historyLore = new ArrayList<String>();
        historyLore.add(ChatColor.GRAY + this.plugin.getMessage("history.hint", "Click to view logs"));
        historyMeta.setLore(historyLore);
        historyBtn.setItemMeta(historyMeta);
        financeInv.setItem(31, historyBtn);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.back-hint", "Return to main menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        financeInv.setItem(49, backBtn);
        player.openInventory(financeInv);
        this.lastOpenedMenu.put(player.getUniqueId(), "finance");
        this.lastTarget.put(player.getUniqueId(), result.name);
    }

    private void openContextMenu(Player player, String targetName) {
        PlayerResult result = this.getPlayerResultByName(targetName);
        if (result == null) {
            player.sendMessage(ChatColor.RED + "\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            return;
        }
        Inventory contextMenu = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("context-menu.title", "Quick Actions for " + targetName)));
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
        contextMenu.setItem(4, this.createPlayerHead(target, 0));
        ItemStack give = new ItemStack(Material.EMERALD);
        ItemMeta giveMeta = give.getItemMeta();
        giveMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("context-menu.give-money", "Give Money"));
        give.setItemMeta(giveMeta);
        contextMenu.setItem(3, give);
        ItemStack take = new ItemStack(Material.REDSTONE);
        ItemMeta takeMeta = take.getItemMeta();
        takeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("context-menu.take-money", "Take Money"));
        take.setItemMeta(takeMeta);
        contextMenu.setItem(5, take);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("context-menu.back-lore", "Return to main menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        contextMenu.setItem(8, backBtn);
        player.openInventory(contextMenu);
        this.lastOpenedMenu.put(player.getUniqueId(), "context");
        this.lastTarget.put(player.getUniqueId(), targetName);
    }

    private void openDigitalMenu(Player player, String action, PlayerResult result) {
        Inventory digitalInv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.title", "Economy Management") + ": " + result.name));
        double totalAmount = this.pendingActionAmount.getOrDefault(player.getUniqueId(), 0.0);
        digitalInv.setItem(4, this.createPlayerHead(Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid)), 0));
        int[] amounts = new int[]{1, 5, 10, 100, 1000, 5000};
        int slot = 9;
        for (int amount : amounts) {
            ItemStack numBtn = new ItemStack(Material.PAPER);
            ItemMeta numMeta = numBtn.getItemMeta();
            numMeta.setDisplayName(ChatColor.YELLOW + String.valueOf(amount));
            ArrayList<String> numLore = new ArrayList<String>();
            numLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.add-amount-hint", "Click to add %amount% to total", "amount", String.valueOf(amount)));
            numLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
            numMeta.setLore(numLore);
            numBtn.setItemMeta(numMeta);
            digitalInv.setItem(slot, numBtn);
            ++slot;
        }
        ItemStack customBtn = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta customMeta = customBtn.getItemMeta();
        customMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("gui.custom-amount", "Custom Amount"));
        ArrayList<String> customLore = new ArrayList<String>();
        customLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.custom-amount-hint", "Left click to enter custom amount in chat"));
        customLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
        customMeta.setLore(customLore);
        customBtn.setItemMeta(customMeta);
        digitalInv.setItem(22, customBtn);
        ItemStack resetBtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta resetMeta = resetBtn.getItemMeta();
        resetMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reset-amount", "Reset Amount"));
        ArrayList<String> resetLore = new ArrayList<String>();
        resetLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.reset-amount-hint", "Reset the selected amount to 0"));
        resetLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-amount", "Current amount: $%amount%", "amount", String.format(this.moneyFormat, totalAmount)));
        resetMeta.setLore(resetLore);
        resetBtn.setItemMeta(resetMeta);
        digitalInv.setItem(18, resetBtn);
        ItemStack confirmBtn = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta confirmMeta = confirmBtn.getItemMeta();
        confirmMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.confirm", "Confirm"));
        ArrayList<String> confirmLore = new ArrayList<String>();
        confirmLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.confirm-hint", "Execute: %action% $%amount%", "action", action, "amount", String.format(this.moneyFormat, totalAmount)));
        confirmMeta.setLore(confirmLore);
        confirmBtn.setItemMeta(confirmMeta);
        digitalInv.setItem(16, confirmBtn);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.back-hint-finance", "Return to finance menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        digitalInv.setItem(26, backBtn);
        player.openInventory(digitalInv);
        this.pendingActionType.put(player.getUniqueId(), action);
        this.pendingActionTarget.put(player.getUniqueId(), result);
        this.lastOpenedMenu.put(player.getUniqueId(), "digital");
    }

    private void openHistoryMenu(Player player, PlayerResult result) {
        Inventory historyInv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("history.title", "Operations History: %player%", "%player%", result.name)));
        List<String> history = this.getPlayerHistory(result.uuid);
        int slot = 0;
        for (String entry : history) {
            ItemStack historyItem = new ItemStack(Material.PAPER);
            ItemMeta meta = historyItem.getItemMeta();
            meta.setDisplayName(ChatColor.WHITE + this.plugin.getMessage("history.operation", "Operation #%number%", "%number%", String.valueOf(slot + 1)));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + entry);
            meta.setLore(lore);
            historyItem.setItemMeta(meta);
            historyInv.setItem(slot, historyItem);
            if (++slot < 45) continue;
            break;
        }
        if (history.isEmpty()) {
            ItemStack noHistory = new ItemStack(Material.BARRIER);
            ItemMeta meta = noHistory.getItemMeta();
            meta.setDisplayName(ChatColor.RED + this.plugin.getMessage("history.empty", "History Empty"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("history.empty-hint", "No recorded operations for %player%", "%player%", result.name));
            meta.setLore(lore);
            noHistory.setItemMeta(meta);
            historyInv.setItem(22, noHistory);
        }
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.back-hint-finance", "Return to finance menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        historyInv.setItem(49, backBtn);
        player.openInventory(historyInv);
        this.lastOpenedMenu.put(player.getUniqueId(), "history");
        this.lastTarget.put(player.getUniqueId(), result.name);
    }

    private void openMassActionsMenu(Player player) {
        Inventory massInv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.mass-menu-title", "Mass Operations")));
        ItemStack giveMass = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta giveMeta = giveMass.getItemMeta();
        giveMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.mass-give", "Give Amount to All Selected"));
        ArrayList<String> giveLore = new ArrayList<String>();
        giveLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-give-hint", "Click to enter amount for all"));
        giveMeta.setLore(giveLore);
        giveMass.setItemMeta(giveMeta);
        massInv.setItem(11, giveMass);
        ItemStack takeMass = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta takeMeta = takeMass.getItemMeta();
        takeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.mass-take", "Take Amount from All Selected"));
        ArrayList<String> takeLore = new ArrayList<String>();
        takeLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-take-hint", "Click to enter amount for all"));
        takeMeta.setLore(takeLore);
        takeMass.setItemMeta(takeMeta);
        massInv.setItem(13, takeMass);
        ItemStack setMass = new ItemStack(Material.GOLD_BLOCK);
        ItemMeta setMeta = setMass.getItemMeta();
        setMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.mass-set", "Set Balance for All Selected"));
        ArrayList<String> setLore = new ArrayList<String>();
        setLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.mass-set-hint", "Click to enter amount for all"));
        setMeta.setLore(setLore);
        setMass.setItemMeta(setMeta);
        massInv.setItem(15, setMass);
        ItemStack backBtn = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backBtn.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-return", "Return to Main Menu"));
        backMeta.setLore(backLore);
        backBtn.setItemMeta(backMeta);
        massInv.setItem(22, backBtn);
        player.openInventory(massInv);
        this.lastOpenedMenu.put(player.getUniqueId(), "mass");
    }

    private List<String> getPlayerHistory(String uuid) {
        List history = this.transactionHistory.getOrDefault(uuid, new ArrayList());
        if (history.isEmpty() && this.plugin.getServer().getPluginManager().getPlugin("Essentials") != null) {
            history.add("Placeholder: " + this.plugin.getMessage("action.give-transaction", "Gave $%amount% by %player% %date%", "amount", "100", "player", "System", "date", "2025-09-07"));
            history.add("Placeholder: " + this.plugin.getMessage("action.take-transaction", "Took $%amount% by %player% %date%", "amount", "50", "player", "System", "date", "2025-09-06"));
        }
        return history;
    }

    private void logTransaction(String uuid, String action, double amount, Player player) {
        String actionKey;
        List history = this.transactionHistory.computeIfAbsent(uuid, k -> new ArrayList());
        switch (action) {
            case "set": {
                actionKey = "action.set-transaction";
                break;
            }
            case "give": {
                actionKey = "action.give-transaction";
                break;
            }
            case "take": {
                actionKey = "action.take-transaction";
                break;
            }
            default: {
                actionKey = "action.unknown-transaction";
            }
        }
        String entry = this.plugin.getMessage(actionKey, "%action%: $%amount% by %player% %date%", "action", action, "amount", String.valueOf(amount), "player", player.getName(), "date", new Date().toString());
        history.add(0, entry);
        if (history.size() > 50) {
            history.remove(history.size() - 1);
        }
    }

    private List<PlayerResult> getFilteredPlayers() {
        ArrayList<PlayerResult> results = new ArrayList<PlayerResult>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            boolean matchesFilter;
            if (player.getName() == null) continue;
            boolean matchesSearch = this.currentSearch.isEmpty() || player.getName().toLowerCase().contains(this.currentSearch.toLowerCase());
            boolean bl = matchesFilter = this.currentFilter == Filter.ALL || this.currentFilter == Filter.ONLINE && player.isOnline() || this.currentFilter == Filter.OFFLINE && !player.isOnline() || this.currentFilter == Filter.SELECTED && this.isSelected(player.getUniqueId().toString());
            if (!matchesSearch || !matchesFilter) continue;
            results.add(new PlayerResult(player.getUniqueId().toString(), player.getName(), player.isOnline(), this.plugin.getEconomy().getBalance(player)));
        }
        results.sort(Comparator.comparingDouble(pr -> pr.balance).reversed());
        return results;
    }

    public void openMainGUI(Player player) {
        this.currentPage = this.lastPage.getOrDefault(player.getUniqueId(), 0);
        this.refreshGUI();
        player.openInventory(this.inventory);
        this.lastOpenedMenu.put(player.getUniqueId(), "main");
        this.playersInGUI.add(player.getUniqueId());
    }

    public void resetSearch(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.currentSearch = "";
        this.currentFilter = Filter.ALL;
        this.currentPage = 0;
        this.selectedPlayers.removeAll(this.playerSelections.getOrDefault(playerUUID, Collections.emptySet()));
        this.playerSelections.remove(playerUUID);
        this.lastPage.put(playerUUID, 0);
        this.lastTarget.remove(playerUUID);
        this.lastOpenedMenu.put(playerUUID, "main");
        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.search-reset", "Search and filters reset."));
        this.openMainGUI(player);
    }

    public void setLastOpenedMenu(UUID playerId, String menu) {
        this.lastOpenedMenu.put(playerId, menu);
    }

    public void setLastTarget(UUID playerId, String target) {
        this.lastTarget.put(playerId, target);
    }

    public PlayerResult getPlayerResultByName(String name) {
        return this.cachedResults.stream().filter(r -> r.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private void requestAmount(Player player, String action, String targetName) {
        PlayerResult result = this.getPlayerResultByName(targetName);
        if (result == null) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-not-found", "Player not found."));
            return;
        }
        player.closeInventory();
        TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount (or click to cancel):"));
        TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
        cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
        message.addExtra((BaseComponent)cancel);
        player.spigot().sendMessage((BaseComponent)message);
        this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.action-cancelled", "Action cancelled."));
                this.openMainGUI(p);
                this.pendingActions.remove(p.getUniqueId());
                this.pendingActionType.remove(p.getUniqueId());
                return;
            }
            try {
                double amount = Double.parseDouble(msg.trim());
                if (amount <= 0.0) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    this.openMainGUI(p);
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                boolean success = false;
                if (action.equals("give")) {
                    success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                    if (success) {
                        this.logTransaction(result.uuid, "give", amount, p);
                    }
                } else if (action.equals("take")) {
                    if (this.plugin.getEconomy().getBalance(target) >= amount) {
                        success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(result.uuid, "take", amount, p);
                        }
                    } else {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.insufficient-funds", "Insufficient funds for %player%", "%player%", target.getName()));
                    }
                }
                if (success) {
                    p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "%action%", action, "%amount%", String.format(this.moneyFormat, amount), "%player%", result.name));
                } else {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                }
                this.openMainGUI(p);
            }
            catch (NumberFormatException e) {
                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                this.openMainGUI(p);
            }
            this.pendingActions.remove(p.getUniqueId());
            this.pendingActionType.remove(p.getUniqueId());
        }));
        this.pendingActionType.put(player.getUniqueId(), action);
        this.pendingActionTarget.put(player.getUniqueId(), result);
    }

    private void requestMassAmount(Player player, String action) {
        player.closeInventory();
        TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount (or click to cancel):"));
        TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
        cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
        message.addExtra((BaseComponent)cancel);
        player.spigot().sendMessage((BaseComponent)message);
        this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.action-cancelled", "Action cancelled."));
                this.openMainGUI(p);
                this.pendingActions.remove(p.getUniqueId());
                this.pendingActionType.remove(p.getUniqueId());
                return;
            }
            try {
                double amount = Double.parseDouble(msg.trim());
                if (amount <= 0.0) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    this.openMainGUI(p);
                    return;
                }
                Set selected = this.playerSelections.getOrDefault(p.getUniqueId(), Collections.emptySet());
                if (selected.isEmpty()) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-players-selected", "No players selected."));
                    this.openMainGUI(p);
                    return;
                }
                int successCount = 0;
                for (UUID uuid : selected) {
                    OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (target.getName() == null) continue;
                    boolean success = false;
                    if (action.equals("mass-give")) {
                        success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(uuid.toString(), "give", amount, p);
                        }
                    } else if (action.equals("mass-take")) {
                        if (this.plugin.getEconomy().getBalance(target) >= amount && (success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess())) {
                            this.logTransaction(uuid.toString(), "take", amount, p);
                        }
                    } else if (action.equals("mass-set")) {
                        double current = this.plugin.getEconomy().getBalance(target);
                        this.plugin.getEconomy().withdrawPlayer(target, current);
                        success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(uuid.toString(), "set", amount, p);
                        }
                    }
                    if (!success) continue;
                    ++successCount;
                }
                String actionName = action.equals("mass-give") ? "gave" : (action.equals("mass-take") ? "took" : "set");
                p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.mass-action-applied", "Applied %action% of $%amount% to %count% players", "%action%", actionName, "%amount%", String.format(this.moneyFormat, amount), "%count%", String.valueOf(successCount)));
                this.openMainGUI(p);
            }
            catch (NumberFormatException e) {
                p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                this.openMainGUI(p);
            }
            this.pendingActions.remove(p.getUniqueId());
            this.pendingActionType.remove(p.getUniqueId());
        }));
        this.pendingActionType.put(player.getUniqueId(), action);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof EconomySearchGUI)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String menu = this.lastOpenedMenu.getOrDefault(playerUUID, "main");
        String displayName = clicked.getItemMeta() != null ? clicked.getItemMeta().getDisplayName() : "";
        long now = System.currentTimeMillis();
        int slot = event.getSlot();
        if (menu.equals("main")) {
            if (slot == 45 || slot == 53) {
                if (now - this.lastPageSwitch.getOrDefault(playerUUID, 0L) < 1000L) {
                    return;
                }
                if (slot == 45 && this.currentPage > 0) {
                    this.lastPageSwitch.put(playerUUID, now);
                    this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.max(0, this.currentPage - 5) : --this.currentPage;
                    this.lastPage.put(playerUUID, this.currentPage);
                    this.refreshGUI();
                } else if (slot == 53 && (this.currentPage + 1) * 36 < this.cachedResults.size()) {
                    this.lastPageSwitch.put(playerUUID, now);
                    int totalPages = this.cachedResults.size() / 36 + (this.cachedResults.size() % 36 > 0 ? 1 : 0);
                    this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.min(totalPages - 1, this.currentPage + 5) : ++this.currentPage;
                    this.lastPage.put(playerUUID, this.currentPage);
                    this.refreshGUI();
                }
            } else if (slot == 46) {
                if (!this.plugin.isPlayerSelectionEnabled()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-selection-disabled", "Player selection is disabled in config!"));
                    return;
                }
                for (PlayerResult result : this.cachedResults.subList(this.currentPage * 36, Math.min((this.currentPage + 1) * 36, this.cachedResults.size()))) {
                    UUID uuid = UUID.fromString(result.uuid);
                    this.selectedPlayers.add(uuid);
                    this.playerSelections.computeIfAbsent(playerUUID, k -> new HashSet()).add(uuid);
                }
                this.refreshGUI();
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.selection-updated", "Selected all players on page."));
            } else if (slot == 47) {
                if (!this.plugin.isPlayerSelectionEnabled()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-selection-disabled", "Player selection is disabled in config!"));
                    return;
                }
                Set selections = this.playerSelections.getOrDefault(playerUUID, Collections.emptySet());
                this.selectedPlayers.removeAll(selections);
                this.playerSelections.remove(playerUUID);
                this.refreshGUI();
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.selection-cleared", "Selection cleared."));
            } else if (slot == 48) {
                if (!this.plugin.isMassOperationsEnabled()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.mass-operations-disabled", "Mass operations are disabled in config!"));
                    return;
                }
                Set selected = this.playerSelections.getOrDefault(playerUUID, Collections.emptySet());
                if (selected.isEmpty()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-players-selected", "No players selected."));
                    return;
                }
                this.openMassActionsMenu(player);
                this.lastOpenedMenu.put(playerUUID, "mass");
            } else if (slot == 4) {
                if (event.getClick() == ClickType.RIGHT) {
                    this.resetSearch(player);
                } else if (event.getClick() == ClickType.LEFT) {
                    player.closeInventory();
                    TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-search", "Enter name to search: "));
                    TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                    cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                    message.addExtra((BaseComponent)cancel);
                    player.spigot().sendMessage((BaseComponent)message);
                    this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        String input = ChatColor.stripColor((String)msg.trim());
                        if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                            this.resetSearch(p);
                            this.pendingActions.remove(p.getUniqueId());
                            return;
                        }
                        this.currentSearch = input;
                        this.currentPage = 0;
                        this.lastPage.put(p.getUniqueId(), 0);
                        this.cachedResults.clear();
                        this.cachedResults = this.getFilteredPlayers();
                        this.setupMainMenuLayout();
                        p.openInventory(this.inventory);
                        this.playersInGUI.add(p.getUniqueId());
                        this.lastOpenedMenu.put(p.getUniqueId(), "main");
                        p.updateInventory();
                        this.pendingActions.remove(p.getUniqueId());
                    }));
                }
            } else if (slot == 49) {
                this.applyFilter(Filter.ALL, player);
            } else if (slot == 50) {
                this.applyFilter(Filter.ONLINE, player);
            } else if (slot == 51) {
                this.applyFilter(Filter.OFFLINE, player);
            } else if (slot >= 9 && slot <= 44) {
                String name = ChatColor.stripColor((String)displayName);
                PlayerResult result = this.cachedResults.stream().filter(r -> r.name.equalsIgnoreCase(name)).findFirst().orElse(null);
                if (result == null) {
                    return;
                }
                if (event.getClick() == ClickType.LEFT) {
                    if (!this.plugin.isFullManagementEnabled()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.full-management-disabled", "Full management is disabled in config!"));
                        return;
                    }
                    this.openPlayerFinanceManagement(player, result);
                    this.lastOpenedMenu.put(playerUUID, "finance");
                    this.lastTarget.put(playerUUID, result.name);
                } else if (event.getClick() == ClickType.RIGHT) {
                    if (!this.plugin.isQuickActionsEnabled()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.quick-actions-disabled", "Quick actions are disabled in config!"));
                        return;
                    }
                    this.openContextMenu(player, name);
                    this.lastOpenedMenu.put(playerUUID, "context");
                    this.lastTarget.put(playerUUID, result.name);
                } else if (event.getClick() == ClickType.SHIFT_LEFT && now - this.lastPageSwitch.getOrDefault(playerUUID, 0L) >= 1000L) {
                    if (!this.plugin.isPlayerSelectionEnabled()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-selection-disabled", "Player selection is disabled in config!"));
                        return;
                    }
                    UUID uuid = UUID.fromString(result.uuid);
                    Set selections = this.playerSelections.computeIfAbsent(playerUUID, k -> new HashSet());
                    if (this.selectedPlayers.contains(uuid)) {
                        this.selectedPlayers.remove(uuid);
                        selections.remove(uuid);
                    } else {
                        this.selectedPlayers.add(uuid);
                        selections.add(uuid);
                    }
                    this.refreshGUI();
                    player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.selection-updated", "Selection updated."));
                }
            }
        } else if (menu.equals("finance")) {
            if (!this.plugin.isFullManagementEnabled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.full-management-disabled", "Full management is disabled in config!"));
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            String targetName = this.lastTarget.get(playerUUID);
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result == null) {
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            if (slot == 13) {
                if (!player.hasPermission("economygui.give")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission to give."));
                    this.openPlayerFinanceManagement(player, result);
                    return;
                }
                player.closeInventory();
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount in chat (or 'cancel' to abort):"));
                TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                        p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                        this.openPlayerFinanceManagement(p, result);
                        this.pendingActions.remove(p.getUniqueId());
                        return;
                    }
                    try {
                        double amount = Double.parseDouble(msg.trim());
                        if (amount <= 0.0) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                            this.openPlayerFinanceManagement(p, result);
                            return;
                        }
                        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                        if (this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) {
                            p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "action", "give", "amount", String.format(this.moneyFormat, amount), "player", result.name));
                            this.logTransaction(result.uuid, "give", amount, p);
                        } else {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                        }
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                    }
                    this.openPlayerFinanceManagement(p, result);
                    this.pendingActions.remove(p.getUniqueId());
                }));
            } else if (slot == 20) {
                this.openDigitalMenu(player, this.plugin.getMessage("action.give", "Give"), result);
                this.lastOpenedMenu.put(playerUUID, "digital");
                this.pendingActionType.put(playerUUID, this.plugin.getMessage("action.give", "Give"));
                this.pendingActionTarget.put(playerUUID, result);
            } else if (slot == 22) {
                this.openDigitalMenu(player, this.plugin.getMessage("action.take", "Take"), result);
                this.lastOpenedMenu.put(playerUUID, "digital");
                this.pendingActionType.put(playerUUID, this.plugin.getMessage("action.take", "Take"));
                this.pendingActionTarget.put(playerUUID, result);
            } else if (slot == 24) {
                if (!player.hasPermission("economygui.set")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission to set."));
                    this.openPlayerFinanceManagement(player, result);
                    return;
                }
                player.closeInventory();
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-amount", "Enter amount in chat (or 'cancel' to abort):"));
                TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (msg.equalsIgnoreCase("cancel") || msg.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                        p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                        this.openPlayerFinanceManagement(p, result);
                        this.pendingActions.remove(p.getUniqueId());
                        return;
                    }
                    try {
                        double amount = Double.parseDouble(msg.trim());
                        if (amount < 0.0) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.negative-amount", "Amount cannot be negative."));
                            this.openPlayerFinanceManagement(p, result);
                            return;
                        }
                        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                        double current = this.plugin.getEconomy().getBalance(target);
                        if (this.plugin.getEconomy().withdrawPlayer(target, current).transactionSuccess() && this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) {
                            p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "action", "set", "amount", String.format(this.moneyFormat, amount), "player", result.name));
                            this.logTransaction(result.uuid, "set", amount, p);
                        } else {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                        }
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                    }
                    this.openPlayerFinanceManagement(p, result);
                    this.pendingActions.remove(p.getUniqueId());
                }));
            } else if (slot == 31) {
                this.openHistoryMenu(player, result);
                this.lastOpenedMenu.put(playerUUID, "history");
                this.lastTarget.put(playerUUID, result.name);
            } else if (slot == 49) {
                this.openMainGUI(player);
                this.lastOpenedMenu.put(playerUUID, "main");
            }
        } else if (menu.equals("context")) {
            if (!this.plugin.isQuickActionsEnabled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.quick-actions-disabled", "Quick actions are disabled in config!"));
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            String targetName = this.lastTarget.get(playerUUID);
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result == null) {
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            if (slot == 3) {
                this.requestAmount(player, "give", targetName);
            } else if (slot == 5) {
                this.requestAmount(player, "take", targetName);
            } else if (slot == 8) {
                this.openMainGUI(player);
                this.lastOpenedMenu.put(playerUUID, "main");
            }
        } else if (menu.equals("digital")) {
            if (!this.plugin.isFullManagementEnabled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.full-management-disabled", "Full management is disabled in config!"));
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            PlayerResult result = this.pendingActionTarget.get(playerUUID);
            if (result == null) {
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            if (slot == 16) {
                double amount = this.pendingActionAmount.getOrDefault(playerUUID, 0.0);
                String action = this.pendingActionType.getOrDefault(playerUUID, this.plugin.getMessage("action.give", "Give"));
                if (amount <= 0.0) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
                boolean success = false;
                if (action.equals(this.plugin.getMessage("action.give", "Give"))) {
                    if (!player.hasPermission("economygui.give")) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission to give."));
                        return;
                    }
                    success = this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess();
                    if (success) {
                        this.logTransaction(result.uuid, "give", amount, player);
                    }
                } else if (action.equals(this.plugin.getMessage("action.take", "Take"))) {
                    if (!player.hasPermission("economygui.take")) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission to take."));
                        return;
                    }
                    if (this.plugin.getEconomy().getBalance(target) >= amount) {
                        success = this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess();
                        if (success) {
                            this.logTransaction(result.uuid, "take", amount, player);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.insufficient-funds", "Insufficient funds for %player%", "player", target.getName()));
                    }
                }
                if (success) {
                    player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.executed", "Executed %action% of $%amount% for %player%", "action", action, "amount", String.format(this.moneyFormat, amount), "player", result.name));
                } else {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.action-failed", "Action failed."));
                }
                this.pendingActionAmount.put(playerUUID, 0.0);
                this.openPlayerFinanceManagement(player, result);
                this.lastOpenedMenu.put(playerUUID, "finance");
            } else if (slot == 18) {
                this.pendingActionAmount.put(playerUUID, 0.0);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", "0"));
                this.openDigitalMenu(player, this.pendingActionType.get(playerUUID), result);
            } else if (slot == 26) {
                this.openPlayerFinanceManagement(player, result);
                this.lastOpenedMenu.put(playerUUID, "finance");
            } else if (slot >= 9 && slot <= 14) {
                int[] amounts = new int[]{1, 5, 10, 100, 1000, 5000};
                int index = slot - 9;
                if (index >= 0 && index < amounts.length) {
                    double currentAmount = this.pendingActionAmount.getOrDefault(playerUUID, 0.0);
                    this.pendingActionAmount.put(playerUUID, currentAmount + (double)amounts[index]);
                    player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", String.valueOf(currentAmount + (double)amounts[index])));
                    this.openDigitalMenu(player, this.pendingActionType.get(playerUUID), result);
                }
            } else if (slot == 22) {
                player.closeInventory();
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-custom", "Enter custom amount: "));
                TextComponent cancel = new TextComponent(ChatColor.RED + this.plugin.getMessage("gui.cancel", "[Cancel]"));
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/economygui reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(playerUUID, (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String input = ChatColor.stripColor((String)msg.trim());
                    if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                        p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                        this.pendingActions.remove(p.getUniqueId());
                        return;
                    }
                    try {
                        double amount = Double.parseDouble(input);
                        if (amount <= 0.0) {
                            p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                            this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                            return;
                        }
                        double currentAmount = this.pendingActionAmount.getOrDefault(p.getUniqueId(), 0.0);
                        this.pendingActionAmount.put(p.getUniqueId(), currentAmount + amount);
                        p.sendMessage(ChatColor.GREEN + this.plugin.getMessage("gui.amount-selected", "Selected amount: %amount%", "amount", String.valueOf(currentAmount + amount)));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                        this.openDigitalMenu(p, this.pendingActionType.get(p.getUniqueId()), this.pendingActionTarget.get(p.getUniqueId()));
                    }
                    this.pendingActions.remove(p.getUniqueId());
                }));
            }
        } else if (menu.equals("history")) {
            PlayerResult result;
            if (slot == 49 && (result = this.getPlayerResultByName(this.lastTarget.get(playerUUID))) != null) {
                if (!this.plugin.isFullManagementEnabled()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.full-management-disabled", "Full management is disabled in config!"));
                    this.openMainGUI(player);
                    this.lastOpenedMenu.put(playerUUID, "main");
                    return;
                }
                this.openPlayerFinanceManagement(player, result);
                this.lastOpenedMenu.put(playerUUID, "finance");
            }
        } else if (menu.equals("mass")) {
            if (!this.plugin.isMassOperationsEnabled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.mass-operations-disabled", "Mass operations are disabled in config!"));
                player.closeInventory();
                this.openMainGUI(player);
                return;
            }
            if (slot == 11) {
                this.requestMassAmount(player, "mass-give");
            } else if (slot == 13) {
                this.requestMassAmount(player, "mass-take");
            } else if (slot == 15) {
                this.requestMassAmount(player, "mass-set");
            } else if (slot == 22) {
                this.openMainGUI(player);
                this.lastOpenedMenu.put(playerUUID, "main");
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.pendingActions.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            String message = event.getMessage();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                ChatAction action = this.pendingActions.get(player.getUniqueId());
                if (action == null) {
                    return;
                }
                if (message.equalsIgnoreCase("cancel") || message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430")) {
                    player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("messages.input-cancelled", "Input cancelled."));
                    this.pendingActions.remove(player.getUniqueId());
                    this.openLastGUIMenu(player);
                    return;
                }
                if (this.pendingActionType.get(player.getUniqueId()) != null && this.pendingActionType.get(player.getUniqueId()).startsWith("mass-")) {
                    String actionType = this.pendingActionType.get(player.getUniqueId());
                    try {
                        double amount = Double.parseDouble(message.trim());
                        if (actionType.equals("mass-set") && amount < 0.0 || !actionType.equals("mass-set") && amount <= 0.0) {
                            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount", "Amount must be positive."));
                            this.openMassActionsMenu(player);
                            return;
                        }
                        int count = 0;
                        for (UUID uuid : this.selectedPlayers) {
                            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)uuid);
                            if (actionType.equals("mass-give")) {
                                if (!this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) continue;
                                ++count;
                                this.logTransaction(uuid.toString(), "give", amount, player);
                                continue;
                            }
                            if (actionType.equals("mass-take")) {
                                if (!(this.plugin.getEconomy().getBalance(target) >= amount) || !this.plugin.getEconomy().withdrawPlayer(target, amount).transactionSuccess()) continue;
                                ++count;
                                this.logTransaction(uuid.toString(), "take", amount, player);
                                continue;
                            }
                            if (!actionType.equals("mass-set") || !this.plugin.getEconomy().withdrawPlayer(target, this.plugin.getEconomy().getBalance(target)).transactionSuccess() || !this.plugin.getEconomy().depositPlayer(target, amount).transactionSuccess()) continue;
                            ++count;
                            this.logTransaction(uuid.toString(), "set", amount, player);
                        }
                        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("messages.mass-action-applied", "Applied %action% on $%amount% to %count% players", "action", actionType.replace("mass-", ""), "amount", String.format(this.moneyFormat, amount), "count", String.valueOf(count)));
                        this.openMassActionsMenu(player);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-amount-format", "Invalid amount format."));
                        this.openMassActionsMenu(player);
                    }
                    this.pendingActions.remove(player.getUniqueId());
                    this.pendingActionType.remove(player.getUniqueId());
                    return;
                }
                action.execute(message, player);
            });
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof EconomySearchGUI) {
            this.playersInGUI.remove(event.getPlayer().getUniqueId());
        }
    }

    public void openLastGUIMenu(Player player) {
        String lastMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "main");
        this.currentPage = this.lastPage.getOrDefault(player.getUniqueId(), 0);
        this.currentSearch = this.lastTarget.getOrDefault(player.getUniqueId(), "");
        this.playersInGUI.add(player.getUniqueId());
        if (lastMenu.equals("main")) {
            this.openMainGUI(player);
        } else if (lastMenu.equals("finance")) {
            String targetName = this.lastTarget.get(player.getUniqueId());
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result != null) {
                this.openPlayerFinanceManagement(player, result);
            }
        } else if (lastMenu.equals("context")) {
            this.openContextMenu(player, this.lastTarget.get(player.getUniqueId()));
        } else if (lastMenu.equals("digital")) {
            PlayerResult result = this.pendingActionTarget.get(player.getUniqueId());
            String action = this.pendingActionType.get(player.getUniqueId());
            if (result != null && action != null) {
                this.openDigitalMenu(player, action, result);
            }
        } else if (lastMenu.equals("history")) {
            String targetName = this.lastTarget.get(player.getUniqueId());
            PlayerResult result = this.getPlayerResultByName(targetName);
            if (result != null) {
                this.openHistoryMenu(player, result);
            }
        } else if (lastMenu.equals("mass")) {
            this.openMassActionsMenu(player);
        }
    }

    public void refreshOpenGUIs() {
        for (UUID uuid : this.playersInGUI) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            this.openLastGUIMenu(player);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static enum Filter {
        ALL,
        ONLINE,
        OFFLINE,
        SELECTED;

    }

    private static class PlayerResult {
        String uuid;
        String name;
        boolean online;
        double balance;

        PlayerResult(String uuid, String name, boolean online, double balance) {
            this.uuid = uuid;
            this.name = name;
            this.online = online;
            this.balance = balance;
        }
    }

    @FunctionalInterface
    static interface ChatAction {
        public void execute(String var1, Player var2);
    }
}

