/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.economyGUI.gson.internal.sql;

import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.stepanyaa.economyGUI.gson.Gson;
import ru.stepanyaa.economyGUI.gson.JsonSyntaxException;
import ru.stepanyaa.economyGUI.gson.TypeAdapter;
import ru.stepanyaa.economyGUI.gson.TypeAdapterFactory;
import ru.stepanyaa.economyGUI.gson.reflect.TypeToken;
import ru.stepanyaa.economyGUI.gson.stream.JsonReader;
import ru.stepanyaa.economyGUI.gson.stream.JsonToken;
import ru.stepanyaa.economyGUI.gson.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s = in.nextString();
        try {
            SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
            synchronized (sqlTimeTypeAdapter) {
                Date date = this.format.parse(s);
                return new Time(date.getTime());
            }
        }
        catch (ParseException e) {
            throw new JsonSyntaxException("Failed parsing '" + s + "' as SQL Time; at path " + in.getPreviousPath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter out, Time value) throws IOException {
        String timeString;
        if (value == null) {
            out.nullValue();
            return;
        }
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            timeString = this.format.format(value);
        }
        out.value(timeString);
    }
}

