/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale;

import deus.painscale.command.PainScaleCommand;
import deus.painscale.entity.mob_skeleton_armored.MobSkeletonArmored;
import deus.painscale.entity.mob_zombie_armored.MobPainScaleZombieArmored;
import deus.painscale.item.PainScaleItems;
import deus.painscale.mechanics.ArmorSets;
import net.fabricmc.api.ModInitializer;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRuleBoolean;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.util.collection.NamespaceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.toml.Toml;

public class PainScaleMod
implements ModInitializer,
RecipeEntrypoint,
GameStartEntrypoint {
    public static final String MOD_ID = "painscale";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"painscale");
    public static TomlConfigHandler CFG;
    private static final Toml TOML;
    public static final RecipeNamespace PSDF;
    public static double base_attack_multiplier_per_level;
    public static double base_health_multiplier_per_level;
    public static double start_attack_multiplier;
    public static double start_health_multiplier;
    public static GameRuleBoolean DYNAMIC_DIFFICULTY;
    public static GameRuleBoolean MORE_HEARTS;
    public static GameRuleBoolean ARMORED_ZOMBIES_PLUS;
    public static GameRuleBoolean MP_NEARBY_PLAYER_AFFECTS;
    public static GameRuleBoolean DAY_SURVIVED_MESSAGE;

    public void onInitialize() {
        base_attack_multiplier_per_level = CFG.getDouble("Enemies.base_attack_multiplier");
        base_health_multiplier_per_level = CFG.getDouble("Enemies.base_attack_multiplier");
        start_attack_multiplier = CFG.getDouble("Enemies.attack_multiplier_per_level");
        start_health_multiplier = CFG.getDouble("Enemies.attack_multiplier_per_level");
        PainScaleItems.init();
        CommandManager.registerCommand((CommandManager.CommandRegistry)new PainScaleCommand());
        EntityHelper.createEntity(MobSkeletonArmored.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"skeleton_armored"), (String)"skeleton_armored");
        EntityHelper.createEntity(MobPainScaleZombieArmored.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"ps_zombie_armored"), (String)"ps_zombie_armored");
        LOGGER.info("PainScale initialized.");
    }

    public void onRecipesReady() {
        RecipeBuilder.Shaped((String)MOD_ID).setShape(new String[]{"OOO", "OGO", "OOO"}).addInput('O', (IItemConvertible)Items.OLIVINE).addInput('G', (IItemConvertible)Items.FOOD_APPLE_GOLD).create("painscale:recipe/olivine_heart", PainScaleItems.OLIVINE_HEART.getDefaultStack());
    }

    public void initNamespaces() {
        RecipeGroup painscale = new RecipeGroup(new RecipeSymbol(new ItemStack(PainScaleItems.OLIVINE_HEART)));
        PSDF.register(MOD_ID, (Object)painscale);
        Registries.RECIPES.register(MOD_ID, PSDF);
    }

    public void beforeGameStart() {
        try {
            TextureRegistry.initializeAllFiles((String)MOD_ID, (AtlasStitcher)TextureRegistry.guiSpriteAtlas, (boolean)true);
            TextureRegistry.initializeAllFiles((String)MOD_ID, (AtlasStitcher)TextureRegistry.particleAtlas, (boolean)true);
        }
        catch (Exception var2) {
            LOGGER.warn("PainScale: Failed to fully initialize assets, some issue may occur!", (Throwable)var2);
        }
    }

    public void afterGameStart() {
        ArmorSets.initialize();
    }

    static {
        TOML = new Toml("Customize your pain :)");
        PSDF = new RecipeNamespace();
        base_attack_multiplier_per_level = 0.0;
        base_health_multiplier_per_level = 0.0;
        start_attack_multiplier = 0.0;
        start_health_multiplier = 0.0;
        DYNAMIC_DIFFICULTY = null;
        MORE_HEARTS = null;
        ARMORED_ZOMBIES_PLUS = null;
        MP_NEARBY_PLAYER_AFFECTS = null;
        DAY_SURVIVED_MESSAGE = null;
        TOML.addCategory("IDs").addEntry("item_id_olivine_heart", (Object)25000);
        TOML.addCategory("Levels").addEntry("min_points_to_level_up", (Object)10).addEntry("points_per_level_multiplier", (Object)50.0).addEntry("minimum_level", (Object)1).addEntry("maximum_level", (Object)100);
        TOML.addCategory("Enemies").addEntry("enable_armored_skeletons", (Object)true).addEntry("scale_monster_health", (Object)true).addEntry("scale_monster_strength", (Object)true).addEntry("base_attack_multiplier", (Object)0.05).addEntry("attack_multiplier_per_level", (Object)0.05).addEntry("base_health_multiplier", (Object)1.0).addEntry("health_multiplier_per_level", (Object)0.05);
        TOML.addCategory("Multiplayer").addEntry("player_proximity_radius", (Object)8);
        TOML.addCategory("Points").addEntry("base_points_per_monster", (Object)10).addEntry("points_per_level_multiplier_per_monster", (Object)10.0).addEntry("level_cost_points_multiplier", (Object)50.0).addEntry("points_gained_per_monster_hit", (Object)1).addEntry("points_per_day_survived_per_level", (Object)20).addEntry("points_lost_on_death_per_level", (Object)20).addEntry("points_lost_when_killed_by_player_per_level", (Object)10);
        CFG = new TomlConfigHandler(MOD_ID, TOML);
        DYNAMIC_DIFFICULTY = (GameRuleBoolean)GameRules.register((GameRule)new GameRuleBoolean("dynamicDifficulty", Boolean.valueOf(true)));
        MORE_HEARTS = (GameRuleBoolean)GameRules.register((GameRule)new GameRuleBoolean("moreHearts", Boolean.valueOf(true)));
        ARMORED_ZOMBIES_PLUS = (GameRuleBoolean)GameRules.register((GameRule)new GameRuleBoolean("armoredZombiesPlus", Boolean.valueOf(true)));
        MP_NEARBY_PLAYER_AFFECTS = (GameRuleBoolean)GameRules.register((GameRule)new GameRuleBoolean("mpNearbyPlayerAffects", Boolean.valueOf(true)));
        DAY_SURVIVED_MESSAGE = (GameRuleBoolean)GameRules.register((GameRule)new GameRuleBoolean("daySurvivedMessage", Boolean.valueOf(true)));
    }
}

