/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mechanics;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import deus.painscale.PainScaleMod;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;

public class ArmorSets {
    public static final List<IArmorItem> defaultSet = new ArrayList<IArmorItem>();
    public static final NavigableMap<Integer, List<List<IArmorItem>>> SETS = new TreeMap<Integer, List<List<IArmorItem>>>();
    public static final HashMap<String, IArmorItem> armorList = new HashMap();
    private static final String CONFIG_DIRECTORY = FabricLoader.getInstance().getGameDir().toString() + "/config/";
    private static final Path CONFIG_PATH = Path.of(CONFIG_DIRECTORY + "/painscale_armor_sets.json", new String[0]);

    public static void initialize() {
        defaultSet.add(null);
        defaultSet.add(null);
        defaultSet.add(null);
        defaultSet.add((IArmorItem)Items.ARMOR_HELMET_LEATHER);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_CHAINMAIL);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_CHAINMAIL);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_CHAINMAIL);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_LEATHER);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_LEATHER);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_LEATHER);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_LEATHER);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_IRON);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_IRON);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_IRON);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_IRON);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_GOLD);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_GOLD);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_GOLD);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_GOLD);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_DIAMOND);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_DIAMOND);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_DIAMOND);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_DIAMOND);
        ArmorSets.addToArmorList(Items.ARMOR_BOOTS_STEEL);
        ArmorSets.addToArmorList(Items.ARMOR_LEGGINGS_STEEL);
        ArmorSets.addToArmorList(Items.ARMOR_CHESTPLATE_STEEL);
        ArmorSets.addToArmorList(Items.ARMOR_HELMET_STEEL);
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                PainScaleMod.LOGGER.info("Loading armor sets from painscale_armor_sets.json");
                Gson gson = new Gson();
                Type type = new TypeToken<TreeMap<Integer, List<List<String>>>>(){}.getType();
                TreeMap config = (TreeMap)gson.fromJson((Reader)reader, type);
                config.forEach((level, sets) -> {
                    ArrayList<String> cset = new ArrayList<String>();
                    sets.forEach(cset::addAll);
                    ArmorSets.register(level, cset);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ArmorSets.createArmorConfig();
        }
    }

    private static void createArmorConfig() {
        PainScaleMod.LOGGER.info("Config doesn't exists, Registering armor sets from painscale");
        ArmorSets.register(0, ArmorSets.get("minecraft:item/armor_boots_leather"), ArmorSets.get("minecraft:item/armor_leggings_leather"));
        ArmorSets.register(0, ArmorSets.get("minecraft:item/armor_chestplate_leather"), ArmorSets.get("minecraft:item/armor_helmet_leather"));
        ArmorSets.register(0, ArmorSets.get("minecraft:item/armor_boots_leather"), ArmorSets.get("minecraft:item/armor_leggings_leather"), ArmorSets.get("minecraft:item/armor_chestplate_leather"), ArmorSets.get("minecraft:item/armor_helmet_leather"));
        ArmorSets.register(15, ArmorSets.get("minecraft:item/armor_boots_iron"), ArmorSets.get("minecraft:item/armor_leggings_iron"), ArmorSets.get("minecraft:item/armor_chestplate_leather"), ArmorSets.get("minecraft:item/armor_helmet_leather"));
        ArmorSets.register(15, ArmorSets.get("minecraft:item/armor_boots_leather"), ArmorSets.get("minecraft:item/armor_leggings_leather"), ArmorSets.get("minecraft:item/armor_chestplate_iron"), ArmorSets.get("minecraft:item/armor_helmet_iron"));
        ArmorSets.register(30, ArmorSets.get("minecraft:item/armor_boots_iron"), ArmorSets.get("minecraft:item/armor_leggings_iron"));
        ArmorSets.register(30, ArmorSets.get("minecraft:item/armor_chestplate_iron"), ArmorSets.get("minecraft:item/armor_helmet_iron"));
        ArmorSets.register(30, ArmorSets.get("minecraft:item/armor_boots_iron"), ArmorSets.get("minecraft:item/armor_leggings_iron"), ArmorSets.get("minecraft:item/armor_chestplate_iron"), ArmorSets.get("minecraft:item/armor_helmet_iron"));
        ArmorSets.register(45, ArmorSets.get("minecraft:item/armor_boots_iron"), ArmorSets.get("minecraft:item/armor_leggings_iron"), ArmorSets.get("minecraft:item/armor_chestplate_gold"), ArmorSets.get("minecraft:item/armor_helmet_gold"));
        ArmorSets.register(45, ArmorSets.get("minecraft:item/armor_boots_gold"), ArmorSets.get("minecraft:item/armor_leggings_gold"), ArmorSets.get("minecraft:item/armor_chestplate_iron"), ArmorSets.get("minecraft:item/armor_helmet_iron"));
        ArmorSets.register(50, ArmorSets.get("minecraft:item/armor_boots_gold"), ArmorSets.get("minecraft:item/armor_leggings_gold"));
        ArmorSets.register(50, ArmorSets.get("minecraft:item/armor_chestplate_gold"), ArmorSets.get("minecraft:item/armor_helmet_gold"));
        ArmorSets.register(50, ArmorSets.get("minecraft:item/armor_boots_gold"), ArmorSets.get("minecraft:item/armor_leggings_gold"), ArmorSets.get("minecraft:item/armor_chestplate_gold"), ArmorSets.get("minecraft:item/armor_helmet_gold"));
        ArmorSets.register(55, ArmorSets.get("minecraft:item/armor_boots_gold"), ArmorSets.get("minecraft:item/armor_leggings_gold"), ArmorSets.get("minecraft:item/armor_chestplate_diamond"), ArmorSets.get("minecraft:item/armor_helmet_diamond"));
        ArmorSets.register(55, ArmorSets.get("minecraft:item/armor_boots_diamond"), ArmorSets.get("minecraft:item/armor_leggings_diamond"), ArmorSets.get("minecraft:item/armor_chestplate_gold"), ArmorSets.get("minecraft:item/armor_helmet_gold"));
        ArmorSets.register(60, ArmorSets.get("minecraft:item/armor_boots_diamond"), ArmorSets.get("minecraft:item/armor_leggings_diamond"));
        ArmorSets.register(60, ArmorSets.get("minecraft:item/armor_chestplate_diamond"), ArmorSets.get("minecraft:item/armor_helmet_diamond"));
        ArmorSets.register(60, ArmorSets.get("minecraft:item/armor_boots_diamond"), ArmorSets.get("minecraft:item/armor_leggings_diamond"), ArmorSets.get("minecraft:item/armor_chestplate_diamond"), ArmorSets.get("minecraft:item/armor_helmet_diamond"));
        ArmorSets.register(75, ArmorSets.get("minecraft:item/armor_boots_diamond"), ArmorSets.get("minecraft:item/armor_leggings_diamond"), ArmorSets.get("minecraft:item/armor_chestplate_steel"), ArmorSets.get("minecraft:item/armor_helmet_steel"));
        ArmorSets.register(75, ArmorSets.get("minecraft:item/armor_boots_steel"), ArmorSets.get("minecraft:item/armor_leggings_steel"), ArmorSets.get("minecraft:item/armor_chestplate_diamond"), ArmorSets.get("minecraft:item/armor_helmet_diamond"));
        ArmorSets.register(90, ArmorSets.get("minecraft:item/armor_boots_steel"), ArmorSets.get("minecraft:item/armor_leggings_steel"));
        ArmorSets.register(90, ArmorSets.get("minecraft:item/armor_chestplate_steel"), ArmorSets.get("minecraft:item/armor_helmet_steel"));
        ArmorSets.register(90, ArmorSets.get("minecraft:item/armor_boots_steel"), ArmorSets.get("minecraft:item/armor_leggings_steel"), ArmorSets.get("minecraft:item/armor_chestplate_steel"), ArmorSets.get("minecraft:item/armor_helmet_steel"));
        ArmorSets.register(100, ArmorSets.get("minecraft:item/armor_boots_steel"), ArmorSets.get("minecraft:item/armor_leggings_steel"), ArmorSets.get("minecraft:item/armor_chestplate_steel"), ArmorSets.get("minecraft:item/armor_helmet_steel"));
        TreeMap stuff = SETS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(innerList -> innerList.stream().map(iArmorItem -> iArmorItem.asItem().namespaceID.toString()).collect(Collectors.toList())).collect(Collectors.toList()), (a, b) -> b, TreeMap::new));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)stuff);
        try (FileWriter fileWriter = new FileWriter(CONFIG_PATH.toFile());){
            fileWriter.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addToArmorList(Item item) {
        armorList.put(item.namespaceID.toString(), (IArmorItem)item);
    }

    private static IArmorItem get(String namespacedId) {
        return armorList.get(namespacedId);
    }

    public static void register(int sinceLvl, IArmorItem ... set) {
        ArrayList<IArmorItem> armorSet = new ArrayList<IArmorItem>();
        for (IArmorItem item : set) {
            if (item == null) {
                PainScaleMod.LOGGER.warn("Not an item");
            }
            armorSet.add(item);
        }
        SETS.computeIfAbsent(sinceLvl, k -> new ArrayList()).add(armorSet);
    }

    public static void register(Integer sinceLvl, List<String> namespaces) {
        ArrayList<IArmorItem> armorSet = new ArrayList<IArmorItem>();
        for (String namespace : namespaces) {
            IArmorItem armorItem = ArmorSets.get(namespace);
            if (armorItem == null) continue;
            armorSet.add(armorItem);
        }
        SETS.computeIfAbsent(sinceLvl, k -> new ArrayList()).add(armorSet);
    }

    public static List<List<IArmorItem>> getArmorSetsForLevel(int lvl) {
        Integer key = SETS.floorKey(lvl);
        return key != null ? (List)SETS.get(key) : List.of(defaultSet);
    }

    public static List<IArmorItem> getArmorSet(int lvl, int index) {
        List<List<IArmorItem>> sets = ArmorSets.getArmorSetsForLevel(lvl);
        return index < sets.size() ? sets.get(index) : defaultSet;
    }

    public static List<IArmorItem> getRandomArmorSet(int lvl) {
        List<List<IArmorItem>> sets = ArmorSets.getArmorSetsForLevel(lvl);
        return sets.get((int)(Math.random() * (double)sets.size()));
    }
}

