/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mixin;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentHealthBar;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.ItemBucketIceCream;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.player.gamemode.Gamemode;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HudComponentHealthBar.class}, priority=900, remap=false)
public class HudComponentHealthBarMixin {
    @Unique
    private final Random random = new Random();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick, CallbackInfo ci) {
        int i;
        boolean heartsFlash;
        HudComponentMovable self = (HudComponentMovable)this;
        int x = self.getLayout().getComponentX(mc, (HudComponent)self, xSizeScreen);
        int y = self.getLayout().getComponentY(mc, (HudComponent)self, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        boolean bl = heartsFlash = mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
        if (mc.thePlayer.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        int health = mc.thePlayer.getHealth();
        int maxHealth = mc.thePlayer.getMaxHealth();
        int prevHealth = mc.thePlayer.prevHealth;
        this.random.setSeed((long)hud.updateCounter * 312871L);
        boolean isHardcore = mc.thePlayer.getGamemode() == Gamemode.hardcore;
        for (i = 0; i < Math.min(maxHealth, 10); ++i) {
            int xHeart = x + i * 8;
            int yHeart = y;
            if (health <= 4) {
                yHeart += this.random.nextInt(2);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            hud.drawGuiIcon(xHeart, yHeart, 9, 9, !heartsFlash ? TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/container") : TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/container_blinking"));
        }
        for (i = 0; i < maxHealth; ++i) {
            int row = i / 10;
            int heartInRow = i % 10;
            int xHeart = x + heartInRow * 8;
            int yHeart = y;
            if (health <= 4) {
                yHeart += this.random.nextInt(2);
            }
            if (heartsFlash) {
                if (i * 2 + 1 < prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full_blinking")));
                }
                if (i * 2 + 1 == prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half_blinking")));
                }
            }
            float[] color = this.rngColor(row);
            GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            if (i * 2 + 1 < health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("painscale:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full")));
            }
            if (i * 2 + 1 == health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("painscale:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half")));
            }
            if (mc.thePlayer.inventory.getCurrentItem() != null && (mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood || mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemBucketIceCream) && ((Boolean)mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) {
                int healing = mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood ? ((ItemFood)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount() : ((ItemBucketIceCream)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount();
                if (i * 2 + 1 >= health) {
                    if (i * 2 + 1 == health) {
                        hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half_right")));
                    } else if (i * 2 + 1 < health + healing) {
                        hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_full")));
                    } else if (i * 2 + 1 == health + healing) {
                        hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture((String)("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half")));
                    }
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ci.cancel();
    }

    @Unique
    private float[] rngColor(int row) {
        float segmentCount;
        float[][] colors = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}};
        float t = Math.min((float)row / 10.0f, 1.0f);
        float scaledT = t * (segmentCount = (float)(colors.length - 1));
        int startIndex = (int)Math.floor(scaledT);
        if ((float)startIndex >= segmentCount) {
            startIndex = (int)(segmentCount - 1.0f);
        }
        float localT = scaledT - (float)startIndex;
        float[] startColor = colors[startIndex];
        float[] endColor = colors[(int)Math.min((float)(startIndex + 1), segmentCount)];
        float r = startColor[0] + localT * (endColor[0] - startColor[0]);
        float g = startColor[1] + localT * (endColor[1] - startColor[1]);
        float b = startColor[2] + localT * (endColor[2] - startColor[2]);
        return new float[]{r, g, b};
    }
}

