/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import deus.painscale.api.IPainScaleMobMonster;
import deus.painscale.api.IPainScalePlayer;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntitySummon;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class PainScaleCommand
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"painscale").requires(source -> ((CommandSource)source).hasAdmin())).then(this.buildModifier("add", true))).then(this.buildModifier("sub", false)).then(this.buildSet()).then(this.buildReset()).then(this.buildGet()).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"summon").requires(source -> ((CommandSource)source).hasAdmin())).then(ArgumentBuilderRequired.argument((String)"entity", (ArgumentType)ArgumentTypeEntitySummon.entity()).then(ArgumentBuilderRequired.argument((String)"level", (ArgumentType)ArgumentTypeInteger.integer()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Vec3 coordinates = source.getCoordinates(false);
            if (source.getSender() != null && coordinates != null) {
                Entity entity = PainScaleCommand.summonEntityAt((CommandContext<Object>)c, coordinates.x, coordinates.y - (double)source.getSender().heightOffset, coordinates.z, 0.0f, 0.0f);
                if (entity instanceof MobMonster) {
                    int level = (Integer)c.getArgument("level", Integer.class);
                    ((IPainScaleMobMonster)entity).ps$setDfLevel(level);
                    int result = ((IPainScaleMobMonster)entity).ps$getDfLevel();
                    ((CommandSource)c.getSource()).sendMessage("Spawned with level: " + result);
                }
                source.sendTranslatableMessage("command.commands.summon.success_single_entity", new Object[]{CommandHelper.getEntityName((Entity)entity)});
                return 1;
            }
            throw CommandExceptions.notInWorld().create();
        })))));
    }

    private ArgumentBuilderLiteral<CommandSource> buildModifier(String literal, boolean isAdd) {
        return (ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)literal).then(ArgumentBuilderLiteral.literal((String)"levels").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.entities()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer()).executes(c -> {
            List entities = ((EntitySelector)c.getArgument("targets", EntitySelector.class)).get((CommandSource)c.getSource());
            int amount = (Integer)c.getArgument("amount", Integer.class);
            int count = 0;
            CommandSource commandSource = (CommandSource)c.getSource();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (isAdd) {
                    ((IPainScalePlayer)player).ps$addLevels(amount);
                    commandSource.sendMessage("Now your level is " + ((IPainScalePlayer)player).ps$getDifficultyLevel());
                } else {
                    ((IPainScalePlayer)player).ps$subLevels(amount);
                    commandSource.sendMessage("Now your level is " + ((IPainScalePlayer)player).ps$getDifficultyLevel());
                }
                ++count;
            }
            return count;
        }))))).then(ArgumentBuilderLiteral.literal((String)"points").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.entities()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer()).executes(c -> {
            List entities = ((EntitySelector)c.getArgument("targets", EntitySelector.class)).get((CommandSource)c.getSource());
            int amount = (Integer)c.getArgument("amount", Integer.class);
            int count = 0;
            CommandSource commandSource = (CommandSource)c.getSource();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (isAdd) {
                    ((IPainScalePlayer)player).ps$addPoints(amount);
                    commandSource.sendMessage("Added " + amount + " points");
                } else {
                    ((IPainScalePlayer)player).ps$subPoints(amount);
                    commandSource.sendMessage("Removed " + amount + " points");
                }
                ++count;
            }
            return count;
        }))));
    }

    private ArgumentBuilderLiteral<CommandSource> buildGet() {
        return (ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"get").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.entities()).executes(c -> {
            List entities = ((EntitySelector)c.getArgument("targets", EntitySelector.class)).get((CommandSource)c.getSource());
            int count = 0;
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                IPainScalePlayer painPlayer = (IPainScalePlayer)player;
                int level = painPlayer.ps$getDifficultyLevel();
                int points = painPlayer.ps$getDifficultyPoints();
                int remainingPoints = painPlayer.ps$getRemainingPoints();
                CommandSource commandSource = (CommandSource)c.getSource();
                commandSource.sendMessage("[PainScale]");
                commandSource.sendMessage("> Level: " + level);
                commandSource.sendMessage("> Points: " + points);
                commandSource.sendMessage("> Remaining: " + remainingPoints);
                commandSource.sendMessage("> Health: " + ((Player)entity).getMaxHealth());
                ++count;
            }
            return count;
        }));
    }

    private static Entity summonEntityAt(CommandContext<Object> c, double x, double y, double z, float yaw, float pitch) {
        Entity entity;
        Class entityClass = (Class)c.getArgument("entity", Class.class);
        try {
            entity = (Entity)entityClass.getConstructor(World.class).newInstance(((CommandSource)c.getSource()).getWorld());
        }
        catch (Exception var12) {
            Exception e = var12;
            throw new RuntimeException(e);
        }
        entity.spawnInit();
        entity.moveTo(x, y, z, yaw, pitch);
        ((CommandSource)c.getSource()).getWorld().entityJoinedWorld(entity);
        return entity;
    }

    private ArgumentBuilderLiteral<CommandSource> buildSet() {
        return (ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"set").then(ArgumentBuilderLiteral.literal((String)"level").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.entities()).then(ArgumentBuilderRequired.argument((String)"levels", (ArgumentType)ArgumentTypeInteger.integer()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            List entities = ((EntitySelector)c.getArgument("targets", EntitySelector.class)).get((CommandSource)c.getSource());
            int amount = (Integer)c.getArgument("levels", Integer.class);
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                IPainScalePlayer player = (IPainScalePlayer)entity;
                player.ps$setDifficultyLevel(amount);
                player.ps$resetPoints();
                source.sendMessage("Pain Scale levels: " + ((IPainScalePlayer)entity).ps$getDifficultyLevel());
            }
            return 1;
        }))));
    }

    private ArgumentBuilderLiteral<CommandSource> buildReset() {
        return (ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"reset").then(ArgumentBuilderRequired.argument((String)"targets", (ArgumentType)ArgumentTypeEntity.entities()).executes(c -> {
            List entities = ((EntitySelector)c.getArgument("targets", EntitySelector.class)).get((CommandSource)c.getSource());
            CommandSource source = (CommandSource)c.getSource();
            int count = 0;
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                IPainScalePlayer player = (IPainScalePlayer)entity;
                player.ps$setDifficultyLevel(0);
                player.ps$resetPoints();
                player.ps$resetLevels();
                player.ps$resetMultiplier();
                player.ps$setMaxHealth(20);
                source.sendMessage("Pain Scale reset: " + ((Player)entity).getDisplayName());
                ++count;
            }
            return count;
        }));
    }
}

