/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mobstuff.containers;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.DamageType;
import org.jetbrains.annotations.Nullable;

public class MobContainerInventory
implements Container {
    public ItemStack[] armorInventory = new ItemStack[4];
    protected int currentItem = 0;
    private ItemStack heldItem;
    public boolean inventoryChanged = false;
    public ItemStack[] mainInventory = new ItemStack[36];
    public Mob mob;

    public MobContainerInventory(Mob mob) {
        this.mob = mob;
    }

    public int getContainerSize() {
        return 10;
    }

    @Nullable
    public ItemStack getItem(int index) {
        ItemStack[] aitemstack = this.mainInventory;
        if (index >= aitemstack.length) {
            index -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        return aitemstack[index];
    }

    @Nullable
    public ItemStack removeItem(int index, int takeAmount) {
        ItemStack[] aitemstack = this.mainInventory;
        if (index >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            index -= this.mainInventory.length;
        }
        if (aitemstack[index] != null) {
            if (aitemstack[index].stackSize <= takeAmount) {
                ItemStack itemstack1 = aitemstack[index];
                aitemstack[index] = null;
                return itemstack1;
            }
            ItemStack itemstack1 = aitemstack[index].splitStack(takeAmount);
            if (aitemstack[index].stackSize <= 0) {
                aitemstack[index] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void setItem(int index, @Nullable ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (index >= aitemstack.length) {
            index -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        aitemstack[index] = itemstack;
    }

    public String getNameTranslationKey() {
        return "container.inventory.name";
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.inventoryChanged = true;
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void sortContainer() {
        InventorySorter.sortInventory((ItemStack[])this.mainInventory, (int)9, (int)(this.mainInventory.length - 1));
    }

    public ItemStack armorItemInSlot(int i) {
        return this.armorInventory[i];
    }

    public void damageArmor(int damage) {
        for (int j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null || !(this.armorInventory[j].getItem() instanceof IArmorItem)) continue;
            this.armorInventory[j].damageItem(damage, (Entity)this.mob);
            if (this.armorInventory[j].stackSize > 0) continue;
            this.armorInventory[j] = null;
        }
    }

    public float getTotalProtectionAmount(DamageType damageType) {
        float protectionPercentage = 0.0f;
        for (int i = 0; i < this.armorInventory.length; ++i) {
            ArmorMaterial material;
            IArmorItem armor;
            ItemStack itemStack = this.armorInventory[i];
            if (itemStack == null || !(itemStack.getItem() instanceof IArmorItem) || (armor = (IArmorItem)itemStack.getItem()).getArmorPiece() != i || (material = armor.getArmorMaterial()) == null) continue;
            protectionPercentage += material.getProtection(damageType) * armor.getArmorPieceProtectionPercentage();
        }
        return protectionPercentage;
    }

    public ListTag writeToNBT(ListTag nbttaglist) {
        CompoundTag nbttagcompound1;
        int j;
        for (j = 0; j < this.mainInventory.length; ++j) {
            if (this.mainInventory[j] == null) continue;
            nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)j);
            this.mainInventory[j].writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        for (j = 0; j < this.armorInventory.length; ++j) {
            if (this.armorInventory[j] == null) continue;
            nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)(j + 100));
            this.armorInventory[j].writeToNBT(nbttagcompound1);
            nbttaglist.addTag((Tag)nbttagcompound1);
        }
        return nbttaglist;
    }

    public void readFromNBT(ListTag nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound = (CompoundTag)nbttaglist.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.readItemStackFromNbt((CompoundTag)nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.mainInventory.length) {
                this.mainInventory[j] = itemstack;
            }
            if (j < 100 || j >= this.armorInventory.length + 100) continue;
            this.armorInventory[j - 100] = itemstack;
        }
    }
}

