/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.entity.mob_skeleton_armored;

import deus.painscale.entity.mob_skeleton_armored.MobSkeletonArmored;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelZombie;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class MobRendererSkeletonArmored
extends MobRendererBiped<MobSkeletonArmored> {
    private final ModelZombie modelArmorChestplate;
    private final ModelZombie modelArmor;

    public MobRendererSkeletonArmored(ModelBiped model, float shadowSize) {
        super(model, shadowSize);
        this.modelBipedMain = model;
        this.modelArmorChestplate = new ModelZombie(1.0f);
        this.modelArmor = new ModelZombie(0.5f);
    }

    public boolean prepareArmor(MobSkeletonArmored entity, int layer, float partialTick) {
        IArmorItem armorItem;
        Item item;
        ItemStack itemstack = entity.ps$getInv().armorItemInSlot(3 - layer);
        if (itemstack != null && (item = itemstack.getItem()) instanceof IArmorItem && (armorItem = (IArmorItem)item).getArmorPiece() == 3 - layer) {
            if (item instanceof ItemQuiver) {
                return false;
            }
            if (item instanceof ItemQuiverEndless) {
                return false;
            }
            if (item == Items.ARMOR_BOOTS_ICESKATES) {
                return false;
            }
            if (armorItem.getArmorMaterial() != null) {
                this.bindTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace(), armorItem.getArmorMaterial().identifier.value(), layer != 2 ? 1 : 2));
                ModelZombie modelBiped = layer != 2 ? this.modelArmorChestplate : this.modelArmor;
                modelBiped.head.visible = layer == 0;
                modelBiped.hair.visible = layer == 0;
                modelBiped.body.visible = layer == 1 || layer == 2;
                modelBiped.armRight.visible = layer == 1;
                modelBiped.armLeft.visible = layer == 1;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                this.setArmorModel((ModelBase)modelBiped);
                return true;
            }
        }
        return false;
    }
}

