/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.entity.mob_skeleton_armored;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import deus.painscale.api.IPainScaleMobInventory;
import deus.painscale.api.IPainScaleMobMonster;
import deus.painscale.mechanics.ArmorSets;
import deus.painscale.mobstuff.containers.MobContainerInventory;
import java.util.List;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobSkeletonArmored
extends MobSkeleton
implements IPainScaleMobInventory {
    public MobContainerInventory inventory = new MobContainerInventory((Mob)this);

    public MobSkeletonArmored(World world) {
        super(world);
    }

    public void spawnInit() {
        IPainScaleMobMonster z2 = (IPainScaleMobMonster)((Object)this);
        List<IArmorItem> set = ArmorSets.getRandomArmorSet(z2.ps$getDfLevel());
        for (IArmorItem armor : set) {
            if (armor == null) continue;
            Item item = armor.asItem();
            int slot = ((ItemArmor)item).getArmorPiece();
            this.inventory.armorInventory[slot] = new ItemStack((Item)armor);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", (Tag)this.inventory.writeToNBT(new ListTag()));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag nbttaglist = tag.getList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
    }

    @Override
    public MobContainerInventory ps$getInv() {
        return this.inventory;
    }

    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (damageType != null && damageType.shouldDamageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            this.inventory.damageArmor(armorDamage);
        }
        super.damageEntity(newDamage, damageType);
    }
}

