/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mixin.mobs.mob_monster;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.nbt.tags.CompoundTag;
import deus.painscale.PainScaleMod;
import deus.painscale.api.IPainScaleMobMonster;
import deus.painscale.api.IPainScalePlayer;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DamageType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobMonster.class}, remap=false)
public class MobMonsterMixin
implements IPainScaleMobMonster {
    @Shadow(remap=false)
    protected int attackStrength;
    @Unique
    double attackPowerMultiplier = 1.0;
    @Unique
    int dfPoints = 5;
    @Unique
    int dfLevel = 0;
    @Unique
    double healthMultiplier = 1.0;

    @Override
    public void ps$setAttackPowerMultiplier(double multiplier) {
        this.attackPowerMultiplier = multiplier;
    }

    @Override
    public double ps$getAttackPower() {
        return (double)this.attackStrength * this.attackPowerMultiplier;
    }

    @Override
    public double ps$getAttackMultiplier() {
        return this.attackPowerMultiplier;
    }

    @Override
    public void ps$setHealthMultiplier(double multiplier) {
        this.healthMultiplier = multiplier;
    }

    @Override
    public int ps$getBaseAttackPower() {
        return this.attackStrength;
    }

    @Override
    public int ps$getDfLevel() {
        return this.dfLevel;
    }

    @Override
    public void ps$setDfLevel(int level) {
        this.dfLevel = level;
    }

    @Override
    public double ps$getHealthMultiplier() {
        return this.healthMultiplier;
    }

    @Override
    public void ps$setDfPoints(int points) {
        this.dfPoints = points;
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")}, remap=false)
    public void test(Entity attacker, int i, DamageType type, CallbackInfoReturnable<Boolean> cir) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            ((IPainScalePlayer)player).ps$addPoints(this.dfPoints);
        }
    }

    @Redirect(method={"attackEntity(Lnet/minecraft/core/entity/Entity;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/entity/Entity;hurt(Lnet/minecraft/core/entity/Entity;ILnet/minecraft/core/util/helper/DamageType;)Z"), remap=false)
    private boolean redirectAttackEntity(Entity instance, Entity attacker, int baseDamage, DamageType type) {
        Entity e = (Entity)this;
        if (PainScaleMod.CFG.getBoolean("Enemies.monster_strength_multiplier")) {
            float newDamage = (float)((double)this.attackStrength * this.attackPowerMultiplier);
            return instance.hurt(attacker, (int)newDamage, type);
        }
        return instance.hurt(attacker, baseDamage, type);
    }

    @ModifyReturnValue(method={"getMaxHealth"}, at={@At(value="RETURN")}, remap=false)
    private int modifyGetMaxHealth(int original) {
        Entity e = (Entity)this;
        if (PainScaleMod.CFG.getBoolean("Enemies.monster_health_multiplier")) {
            return (int)Math.max(Math.round((double)original * this.healthMultiplier), (long)original);
        }
        return original;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.putInt("PsDfLevel", this.dfLevel);
        tag.putInt("PsDfPoints", this.dfPoints);
        tag.putDouble("PsDfAttackPowerMultiplier", this.attackPowerMultiplier);
        tag.putDouble("PsHealthMultiplier", this.healthMultiplier);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.dfLevel = tag.getInteger("PsDfLevel");
        this.dfPoints = tag.getInteger("PsDfPoints");
        this.attackPowerMultiplier = tag.getDouble("PsDfAttackPowerMultiplier");
        this.healthMultiplier = tag.getDouble("PsHealthMultiplier");
    }
}

