/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mixin.mobs.zombie_armored;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import deus.painscale.PainScaleMod;
import deus.painscale.api.IPainScaleMobInventory;
import deus.painscale.api.IPainScaleMobMonster;
import deus.painscale.mechanics.ArmorSets;
import deus.painscale.mobstuff.containers.MobContainerInventory;
import java.util.List;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MobZombieArmored.class}, remap=false)
public class MobZombieArmoredMixin
extends MobZombie
implements IPainScaleMobInventory {
    @Unique
    public MobContainerInventory inventory;

    public MobZombieArmoredMixin(World world) {
        super(world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void afterInit(World world, CallbackInfo ci) {
        this.inventory = new MobContainerInventory((Mob)((MobZombieArmored)this));
    }

    @Inject(method={"spawnInit"}, at={@At(value="TAIL")}, remap=false)
    public void afterSpawnInit(CallbackInfo ci) {
        IPainScaleMobMonster z2 = (IPainScaleMobMonster)((Object)this);
        List<IArmorItem> set = this.world != null && (Boolean)this.world.getGameRuleValue((GameRule)PainScaleMod.ARMORED_ZOMBIES_PLUS) != false ? ArmorSets.getRandomArmorSet(z2.ps$getDfLevel()) : ArmorSets.defaultSet;
        for (IArmorItem armor : set) {
            if (armor == null) continue;
            Item item = armor.asItem();
            int slot = ((ItemArmor)item).getArmorPiece();
            this.inventory.armorInventory[slot] = new ItemStack((Item)armor);
        }
    }

    @Override
    public MobContainerInventory ps$getInv() {
        return this.inventory;
    }

    @Overwrite(remap=false)
    public boolean hurt(Entity attacker, int i, DamageType type) {
        int lastHealth = this.getHealth();
        return super.hurt(attacker, i, type);
    }

    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (damageType != null && damageType.shouldDamageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            this.inventory.damageArmor(armorDamage);
        }
        super.damageEntity(newDamage, damageType);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.put("Inventory", (Tag)this.inventory.writeToNBT(new ListTag()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        ListTag nbttaglist = tag.getList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
    }
}

