/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mechanics;

import deus.painscale.PainScaleMod;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;

public class ArmorSets {
    public static final NavigableMap<Integer, List<List<IArmorItem>>> SETS = new TreeMap<Integer, List<List<IArmorItem>>>();
    public static final List<IArmorItem> defaultSet = new ArrayList<IArmorItem>();

    public static void initialize() {
        defaultSet.add(null);
        defaultSet.add(null);
        defaultSet.add(null);
        defaultSet.add((IArmorItem)Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.register(0, Items.ARMOR_BOOTS_LEATHER, Items.ARMOR_LEGGINGS_LEATHER);
        ArmorSets.register(0, Items.ARMOR_CHESTPLATE_CHAINMAIL, Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.register(0, Items.ARMOR_BOOTS_CHAINMAIL, Items.ARMOR_LEGGINGS_CHAINMAIL);
        ArmorSets.register(0, Items.ARMOR_CHESTPLATE_LEATHER, Items.ARMOR_HELMET_LEATHER);
        ArmorSets.register(0, Items.ARMOR_BOOTS_LEATHER, Items.ARMOR_LEGGINGS_LEATHER, Items.ARMOR_CHESTPLATE_LEATHER, Items.ARMOR_HELMET_LEATHER);
        ArmorSets.register(0, Items.ARMOR_BOOTS_CHAINMAIL, Items.ARMOR_LEGGINGS_CHAINMAIL, Items.ARMOR_CHESTPLATE_CHAINMAIL, Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.register(30, Items.ARMOR_BOOTS_CHAINMAIL, Items.ARMOR_LEGGINGS_CHAINMAIL);
        ArmorSets.register(30, Items.ARMOR_CHESTPLATE_IRON, Items.ARMOR_HELMET_IRON);
        ArmorSets.register(30, Items.ARMOR_BOOTS_IRON, Items.ARMOR_LEGGINGS_IRON);
        ArmorSets.register(30, Items.ARMOR_CHESTPLATE_CHAINMAIL, Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.register(30, Items.ARMOR_BOOTS_CHAINMAIL, Items.ARMOR_LEGGINGS_CHAINMAIL, Items.ARMOR_CHESTPLATE_CHAINMAIL, Items.ARMOR_HELMET_CHAINMAIL);
        ArmorSets.register(30, Items.ARMOR_BOOTS_IRON, Items.ARMOR_LEGGINGS_IRON, Items.ARMOR_CHESTPLATE_IRON, Items.ARMOR_HELMET_IRON);
        ArmorSets.register(60, Items.ARMOR_BOOTS_IRON, Items.ARMOR_LEGGINGS_IRON);
        ArmorSets.register(60, Items.ARMOR_CHESTPLATE_DIAMOND, Items.ARMOR_HELMET_DIAMOND);
        ArmorSets.register(60, Items.ARMOR_BOOTS_DIAMOND, Items.ARMOR_LEGGINGS_DIAMOND);
        ArmorSets.register(60, Items.ARMOR_CHESTPLATE_IRON, Items.ARMOR_HELMET_IRON);
        ArmorSets.register(60, Items.ARMOR_BOOTS_IRON, Items.ARMOR_LEGGINGS_IRON, Items.ARMOR_CHESTPLATE_IRON, Items.ARMOR_HELMET_IRON);
        ArmorSets.register(60, Items.ARMOR_BOOTS_DIAMOND, Items.ARMOR_LEGGINGS_DIAMOND, Items.ARMOR_CHESTPLATE_DIAMOND, Items.ARMOR_HELMET_DIAMOND);
        ArmorSets.register(90, Items.ARMOR_BOOTS_DIAMOND, Items.ARMOR_LEGGINGS_DIAMOND);
        ArmorSets.register(90, Items.ARMOR_CHESTPLATE_STEEL, Items.ARMOR_HELMET_STEEL);
        ArmorSets.register(90, Items.ARMOR_BOOTS_STEEL, Items.ARMOR_LEGGINGS_STEEL);
        ArmorSets.register(90, Items.ARMOR_CHESTPLATE_DIAMOND, Items.ARMOR_HELMET_DIAMOND);
        ArmorSets.register(90, Items.ARMOR_BOOTS_DIAMOND, Items.ARMOR_LEGGINGS_DIAMOND, Items.ARMOR_CHESTPLATE_DIAMOND, Items.ARMOR_HELMET_DIAMOND);
        ArmorSets.register(90, Items.ARMOR_BOOTS_STEEL, Items.ARMOR_LEGGINGS_STEEL, Items.ARMOR_CHESTPLATE_STEEL, Items.ARMOR_HELMET_STEEL);
        ArmorSets.register(100, Items.ARMOR_BOOTS_STEEL, Items.ARMOR_LEGGINGS_STEEL, Items.ARMOR_CHESTPLATE_STEEL, Items.ARMOR_HELMET_STEEL);
    }

    public static void register(int sinceLvl, Item ... set) {
        ArrayList<IArmorItem> armorSet = new ArrayList<IArmorItem>();
        for (Item item : set) {
            if (item == null) {
                PainScaleMod.LOGGER.warn("Not an item");
            } else if (!(item instanceof IArmorItem)) {
                throw new IllegalArgumentException("Item " + item + " does not implement IArmorItem!");
            }
            armorSet.add((IArmorItem)item);
        }
        SETS.computeIfAbsent(sinceLvl, k -> new ArrayList()).add(armorSet);
    }

    public static List<List<IArmorItem>> getArmorSetsForLevel(int lvl) {
        Integer key = SETS.floorKey(lvl);
        return key != null ? (List)SETS.get(key) : List.of(defaultSet);
    }

    public static List<IArmorItem> getArmorSet(int lvl, int index) {
        List<List<IArmorItem>> sets = ArmorSets.getArmorSetsForLevel(lvl);
        return index < sets.size() ? sets.get(index) : defaultSet;
    }

    public static List<IArmorItem> getRandomArmorSet(int lvl) {
        List<List<IArmorItem>> sets = ArmorSets.getArmorSetsForLevel(lvl);
        return sets.get((int)(Math.random() * (double)sets.size()));
    }
}

