/*
 * Decompiled with CFR 0.152.
 */
package deus.painscale.mixin.player;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.nbt.tags.CompoundTag;
import deus.painscale.PainScaleMod;
import deus.painscale.api.IPainScalePlayer;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerMixin
extends Mob
implements IPainScalePlayer {
    @Unique
    protected int dfLevel = 0;
    @Unique
    protected int dfPoints = 0;
    @Unique
    protected int dfPointsToGrow = 10;
    @Unique
    protected double dfPointsToGrowMultiplier = 0.0;
    @Unique
    int survivedDayCount = 0;
    @Unique
    boolean isFirstTick = true;
    @Unique
    private int maxHealth = 20;
    @Unique
    int dayCountLastTick = -1;
    @Unique
    private boolean killedBy = false;
    @Shadow(remap=false)
    @Final
    private int damageRemainder;
    @Shadow(remap=false)
    public float cameraVelocity;
    @Shadow
    public int portalID;

    @Shadow(remap=false)
    public abstract void readAdditionalSaveData(@NotNull CompoundTag var1);

    @Shadow
    public abstract void addAdditionalSaveData(@NotNull CompoundTag var1);

    @Shadow
    public abstract void sendMessage(String var1);

    public PlayerMixin(@Nullable World world) {
        super(world);
    }

    @Override
    public int ps$getDifficultyLevel() {
        return this.dfLevel;
    }

    @Override
    public int ps$getDifficultyPoints() {
        return this.dfPoints;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.putInt("PsDfLevel", this.dfLevel);
        tag.putInt("PsDfPoints", this.dfPoints);
        tag.putInt("PsDfPointsRemaining", this.dfPointsToGrow);
        tag.putDouble("PsDfPointsToGrowMultiplier", this.dfPointsToGrowMultiplier);
        tag.putInt("PsDfMaxHealth", Math.max(this.maxHealth, 20));
        tag.putInt("PsDfSurvivedDayCount", this.survivedDayCount);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, remap=false)
    public void modifiedReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.dfLevel = tag.getInteger("PsDfLevel");
        this.dfPoints = tag.getInteger("PsDfPoints");
        this.maxHealth = Math.max(tag.getInteger("PsDfMaxHealth"), 20);
        this.dfPointsToGrow = tag.getInteger("PsDfPointsRemaining");
        this.dfPointsToGrowMultiplier = tag.getDouble("PsDfPointsToGrowMultiplier");
        this.survivedDayCount = tag.getInteger("PsDfSurvivedDayCount");
    }

    @ModifyReturnValue(method={"getMaxHealth"}, at={@At(value="RETURN")}, remap=false)
    private int modifyGetMaxHealth(int original) {
        if (((Boolean)this.world.getGameRuleValue((GameRule)PainScaleMod.MORE_HEARTS)).booleanValue()) {
            return Math.max(this.maxHealth, 20);
        }
        return 20;
    }

    @Override
    public boolean ps$wasKilledByPlayer() {
        return this.killedBy;
    }

    @Override
    public void ps$addPoints(int amount) {
        while (amount > 0) {
            this.dfPoints += amount;
            int remainingToLevelUp = this.dfPointsToGrow;
            if (amount >= remainingToLevelUp) {
                this.dfLevel = Math.min(this.dfLevel + 1, PainScaleMod.CFG.getInt("Levels.max_df_level"));
                amount -= remainingToLevelUp;
                this.dfPointsToGrowMultiplier += PainScaleMod.CFG.getDouble("Levels.min_df_points_multiplier");
                this.dfPointsToGrow = (int)Math.round((double)PainScaleMod.CFG.getInt("Levels.min_df_points_to_grow_up") * this.dfPointsToGrowMultiplier);
                continue;
            }
            this.dfPointsToGrow -= amount;
            amount = 0;
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    public void postTick(CallbackInfo ci) {
        if (this.world != null) {
            int currentDayCount = (int)(this.world.getLevelData().getWorldTime() / 24000L);
            if (this.isFirstTick) {
                this.dayCountLastTick = currentDayCount;
                this.isFirstTick = false;
            } else if (currentDayCount != this.dayCountLastTick) {
                this.dayCountLastTick = currentDayCount;
                ++this.survivedDayCount;
                int points = PainScaleMod.CFG.getInt("Points.gain_per_survived_day_per_level") * this.dfLevel;
                this.ps$addPoints(points);
                if (((Boolean)this.world.getGameRuleValue((GameRule)PainScaleMod.DAY_SURVIVED_MESSAGE)).booleanValue()) {
                    this.sendMessage("You have survived " + this.survivedDayCount + " days!");
                    this.sendMessage("You have earned " + points + " points!");
                }
            }
        }
    }

    @Inject(method={"attackTargetEntityWithCurrentItem"}, at={@At(value="TAIL")}, remap=false)
    public void addPointsOnAttackTargetEntityWithCurrentItem(Entity entity, CallbackInfo ci) {
        this.ps$addPoints(PainScaleMod.CFG.getInt("Points.gain_on_monster_attack"));
    }

    @Inject(method={"onDeath"}, at={@At(value="TAIL")}, remap=false)
    public void losePointsWhenKilledBy(Entity entityKilledBy, CallbackInfo ci) {
        if (entityKilledBy instanceof Player) {
            this.killedBy = true;
        }
    }

    @Override
    public void ps$subPoints(int amount) {
        if (this.dfPoints >= amount) {
            this.dfPoints -= amount;
            this.dfPointsToGrow += amount;
        } else {
            int spent = this.dfPoints;
            this.dfPoints = 0;
            this.dfPointsToGrow += spent;
            if (this.dfLevel > PainScaleMod.CFG.getInt("Levels.min_df_level")) {
                --this.dfLevel;
            }
        }
    }

    @Override
    public void ps$addLevels(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.ps$addPoints(this.dfPointsToGrow);
        }
    }

    @Override
    public void ps$subLevels(int amount) {
        int minLevel = PainScaleMod.CFG.getInt("Levels.min_df_level");
        for (int i = 0; i < amount && this.dfLevel > minLevel; ++i) {
            --this.dfLevel;
        }
    }

    @Override
    public void ps$resetMultiplier() {
        this.dfPointsToGrowMultiplier = PainScaleMod.CFG.getDouble("Levels.min_df_points_multiplier");
    }

    @Override
    public void ps$resetPoints() {
        this.dfPointsToGrow = (int)Math.round((double)PainScaleMod.CFG.getInt("Levels.min_df_points_to_grow_up") * this.dfPointsToGrowMultiplier);
        this.dfPoints = 0;
    }

    @Override
    public void ps$resetLevels() {
        this.dfLevel = Math.min(this.dfLevel + 1, PainScaleMod.CFG.getInt("Levels.min_df_level"));
        this.ps$resetPoints();
    }

    @Override
    public int ps$getRemainingPoints() {
        return this.dfPointsToGrow;
    }

    @Override
    public void ps$setPointsMultiplier(double points) {
        this.dfPointsToGrowMultiplier = points;
    }

    @Override
    public void ps$setDifficultyLevels(int levels) {
        this.dfLevel = levels;
    }

    @Override
    public void ps$setDifficultyPoints(int points) {
        this.dfPoints = points;
    }

    @Override
    public void ps$setRemainingPoints(int points) {
        this.dfPointsToGrow = points;
    }

    @Override
    public double ps$getPointsMultiplier() {
        return this.dfPointsToGrowMultiplier;
    }

    @Override
    public void ps$setMaxHealth(int value) {
        if (((Boolean)this.world.getGameRuleValue((GameRule)PainScaleMod.MORE_HEARTS)).booleanValue()) {
            this.maxHealth = Math.max(value, 20);
            this.setHealthRaw(Math.max(value, 20));
        }
    }

    @Override
    public void ps$setDifficultyLevel(int level) {
        this.dfLevel = level;
    }
}

