/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_nether_ores.registries;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((String)"resource_nether_ores", (Registry)BuiltInRegistries.BLOCK);
    private static final RegistryProvider<Item> ITEMS = RegistryProvider.get((String)"resource_nether_ores", (Registry)BuiltInRegistries.ITEM);
    public static final RegistryObject<Block> NETHER_COAL_ORE = BlockRegistry.register("nether_coal_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_ORE));
    public static final RegistryObject<Block> NETHER_COPPER_ORE = BlockRegistry.register("nether_copper_ore_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_ORE));
    public static final RegistryObject<Block> NETHER_IRON_ORE = BlockRegistry.register("nether_iron_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE));
    public static final RegistryObject<Block> NETHER_DIAMOND_ORE = BlockRegistry.register("nether_diamond_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE));
    public static final RegistryObject<Block> NETHER_EMERALD_ORE = BlockRegistry.register("nether_emerald_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.EMERALD_ORE));
    public static final RegistryObject<Block> NETHER_LAPIS_ORE = BlockRegistry.register("nether_lapis_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)5), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_ORE));
    public static final RegistryObject<Block> NETHER_REDSTONE_ORE = BlockRegistry.register("nether_redstone_ore", RedStoneOreBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE));

    private static RegistryObject<Block> register(String id, Supplier<Block> block) {
        RegistryObject toReturn = BLOCKS.register(id, block);
        ITEMS.register(id, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    private static RegistryObject<Block> register(String id, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        RegistryObject toReturn = BLOCKS.register(id, () -> (Block)function.apply(properties.setId(BlockRegistry.blockKey(id))));
        BlockRegistry.registerItem(id, props -> new BlockItem((Block)toReturn.get(), props.useBlockDescriptionPrefix()));
        return toReturn;
    }

    private static void registerItem(String id, Function<Item.Properties, Item> function) {
        ITEMS.register(id, () -> (Item)function.apply(new Item.Properties().setId(BlockRegistry.itemKey(id))));
    }

    private static ResourceKey<Block> blockKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BLOCKS.getModId(), (String)id));
    }

    private static ResourceKey<Item> itemKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ITEMS.getModId(), (String)id));
    }

    public static void init() {
    }
}

