/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_nether_ores.registries;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((ResourceKey)Registries.BLOCK, (String)"resource_nether_ores");
    private static final RegistryProvider<Item> ITEMS = RegistryProvider.get((ResourceKey)Registries.ITEM, (String)"resource_nether_ores");
    public static final RegistryObject<Block> NETHER_COAL_ORE = BlockRegistry.register("nether_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_ORE)));
    public static final RegistryObject<Block> NETHER_COPPER_ORE = BlockRegistry.register("nether_copper_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_ORE)));
    public static final RegistryObject<Block> NETHER_IRON_ORE = BlockRegistry.register("nether_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE)));
    public static final RegistryObject<Block> NETHER_DIAMOND_ORE = BlockRegistry.register("nether_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE)));
    public static final RegistryObject<Block> NETHER_EMERALD_ORE = BlockRegistry.register("nether_emerald_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.EMERALD_ORE)));
    public static final RegistryObject<Block> NETHER_LAPIS_ORE = BlockRegistry.register("nether_lapis_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)5), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_ORE)));
    public static final RegistryObject<Block> NETHER_REDSTONE_ORE = BlockRegistry.register("nether_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE)));

    private static RegistryObject<Block> register(String id, Supplier<Block> block) {
        RegistryObject toReturn = BLOCKS.register(id, block);
        ITEMS.register(id, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static void init() {
    }
}

