/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_nether_ores.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.xstopho.resource_nether_ores.worldgen.OreConfiguredFeatures;
import net.xstopho.resource_nether_ores.worldgen.util.OrePlacementUtil;

public class OrePlacedFeatures {
    public static final ResourceKey<PlacedFeature> NETHER_COAL_ORE_FEATURE = OrePlacedFeatures.createKey("nether_coal_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_COPPER_ORE_FEATURE = OrePlacedFeatures.createKey("nether_copper_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_DIAMOND_ORE_FEATURE = OrePlacedFeatures.createKey("nether_diamond_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_EMERALD_ORE_FEATURE = OrePlacedFeatures.createKey("nether_emerald_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_IRON_ORE_FEATURE = OrePlacedFeatures.createKey("nether_iron_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_LAPIS_ORE_FEATURE = OrePlacedFeatures.createKey("nether_lapis_ore_feature");
    public static final ResourceKey<PlacedFeature> NETHER_REDSTONE_ORE_FEATURE = OrePlacedFeatures.createKey("nether_redstone_ore_feature");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter lookup = context.lookup(Registries.CONFIGURED_FEATURE);
        OrePlacedFeatures.register(context, NETHER_COAL_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_COAL_ORE_KEY), OrePlacedFeatures.common(20, 25, 115));
        OrePlacedFeatures.register(context, NETHER_COPPER_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_COPPER_ORE_KEY), OrePlacedFeatures.common(6, 25, 105));
        OrePlacedFeatures.register(context, NETHER_DIAMOND_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_DIAMOND_ORE_KEY), OrePlacedFeatures.common(3, 90, 125));
        OrePlacedFeatures.register(context, NETHER_EMERALD_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_EMERALD_ORE_KEY), OrePlacedFeatures.common(4, 25, 55));
        OrePlacedFeatures.register(context, NETHER_IRON_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_IRON_ORE_KEY), OrePlacedFeatures.common(40, 40, 110));
        OrePlacedFeatures.register(context, NETHER_LAPIS_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_LAPIS_ORE_KEY), OrePlacedFeatures.common(2, 30, 60));
        OrePlacedFeatures.register(context, NETHER_REDSTONE_ORE_FEATURE, lookup.getOrThrow(OreConfiguredFeatures.NETHER_REDSTONE_ORE_KEY), OrePlacedFeatures.common(8, 80, 115));
    }

    private static List<PlacementModifier> common(int count, int min, int max) {
        return OrePlacementUtil.commonOrePlacement(count, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)min), (VerticalAnchor)VerticalAnchor.absolute((int)max)));
    }

    private static ResourceKey<PlacedFeature> createKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_nether_ores", (String)id));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> config, List<PlacementModifier> modifer) {
        context.register(key, (Object)new PlacedFeature(config, List.copyOf(modifer)));
    }
}

