/*
 * Decompiled with CFR 0.152.
 */
package com.thegameratort.sneakutils.gui;

import com.thegameratort.sneakutils.SneakUtils;
import com.thegameratort.sneakutils.config.SneakUtilsConfig;
import com.thegameratort.sneakutils.config.SneakUtilsConfigFile;
import com.thegameratort.sneakutils.config.SneakUtilsConfigManager;
import com.thegameratort.sneakutils.gui.ButtonListEntry;
import com.thegameratort.sneakutils.gui.ConfigFloatBounds;
import com.thegameratort.sneakutils.gui.ConfigIntBounds;
import com.thegameratort.sneakutils.gui.SeparatorListEntry;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SneakUtilsConfigScreen {
    private static final Logger logger = LogManager.getLogger();

    public static class_437 get(class_437 parent) {
        SneakUtilsConfigManager configManager = SneakUtils.getConfigManager();
        return configManager.isConfigLoaded() ? SneakUtilsConfigScreen.getCurrent(parent) : SneakUtilsConfigScreen.getDefault(parent);
    }

    public static class_437 getCurrent(class_437 parent) {
        SneakUtilsConfigManager configManager = SneakUtils.getConfigManager();
        return SneakUtilsConfigScreen.createScreen(parent, configManager.getConfigFile(), configManager.getDefaultConfig(), true);
    }

    public static class_437 getDefault(class_437 parent) {
        SneakUtilsConfigManager configManager = SneakUtils.getConfigManager();
        return SneakUtilsConfigScreen.createScreen(parent, configManager.getDefaultConfigFile(), new SneakUtilsConfig(), false);
    }

    private static class_437 createScreen(class_437 parent, SneakUtilsConfigFile configFile, SneakUtilsConfig defConfig, boolean isCurrent) {
        Field[] fields;
        SneakUtilsConfig config = configFile.getConfig();
        SneakUtilsConfigManager configManager = SneakUtils.getConfigManager();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"text.sneakutils.title"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory options = builder.getOrCreateCategory((class_2561)class_2561.method_43473());
        if (isCurrent) {
            ButtonListEntry switchConfigBtnEntry = new ButtonListEntry((class_2561)class_2561.method_43471((String)"option.sneakutils.defaultConfig"), (class_2561)class_2561.method_43471((String)"text.sneakutils.edit"), null, () -> {
                class_310 client = class_310.method_1551();
                client.method_1507(SneakUtilsConfigScreen.getDefault(parent));
            });
            options.addEntry((AbstractConfigListEntry)switchConfigBtnEntry);
            String entryText = class_2477.method_10517().method_48307("option.sneakutils.currentConfigSeparator").formatted(configManager.getCurrentWorldName());
            options.addEntry((AbstractConfigListEntry)new SeparatorListEntry((class_2561)class_2561.method_43470((String)entryText)));
        } else {
            if (configManager.isConfigLoaded()) {
                String entryText = class_2477.method_10517().method_48307("option.sneakutils.currentConfig").formatted(configManager.getCurrentWorldName());
                ButtonListEntry switchConfigBtnEntry = new ButtonListEntry((class_2561)class_2561.method_43470((String)entryText), (class_2561)class_2561.method_43471((String)"text.sneakutils.edit"), null, () -> {
                    class_310 client = class_310.method_1551();
                    client.method_1507(SneakUtilsConfigScreen.getCurrent(parent));
                });
                options.addEntry((AbstractConfigListEntry)switchConfigBtnEntry);
            }
            options.addEntry((AbstractConfigListEntry)new SeparatorListEntry((class_2561)class_2561.method_43471((String)"option.sneakutils.defaultConfigSeparator")));
        }
        for (Field field : fields = SneakUtilsConfig.class.getFields()) {
            Class<Comparable<Boolean>> type = field.getType();
            if (type.isAssignableFrom(Boolean.TYPE)) {
                SneakUtilsConfigScreen.addBooleanField(config, defConfig, field, options, entryBuilder);
                continue;
            }
            if (type.isAssignableFrom(Float.TYPE)) {
                SneakUtilsConfigScreen.addFloatField(config, defConfig, field, options, entryBuilder);
                continue;
            }
            if (type.isAssignableFrom(Integer.TYPE)) {
                SneakUtilsConfigScreen.addIntField(config, defConfig, field, options, entryBuilder);
                continue;
            }
            if (type.isAssignableFrom(Long.TYPE)) {
                SneakUtilsConfigScreen.addLongField(config, defConfig, field, options, entryBuilder);
                continue;
            }
            if (!type.isEnum()) continue;
            SneakUtilsConfigScreen.addEnumField(config, defConfig, field, options, entryBuilder);
        }
        builder.setSavingRunnable(configFile::save);
        return builder.build();
    }

    private static void addBooleanField(SneakUtilsConfig config, SneakUtilsConfig defConfig, Field field, ConfigCategory options, ConfigEntryBuilder entryBuilder) {
        boolean defValue;
        boolean value;
        try {
            value = field.getBoolean(config);
            defValue = field.getBoolean(defConfig);
        }
        catch (Exception ex) {
            logger.error("Could not get boolean from config class.", (Throwable)ex);
            return;
        }
        String key = field.getName();
        BooleanToggleBuilder btb = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)("option.sneakutils." + key)), value);
        btb.setTooltip(new class_2561[]{class_2561.method_43471((String)("option.sneakutils.tooltip." + key))});
        btb.setDefaultValue(defValue);
        btb.setSaveConsumer(newValue -> {
            try {
                field.setBoolean(config, (boolean)newValue);
            }
            catch (Exception ex) {
                logger.error("Could not set boolean to config class.", (Throwable)ex);
            }
        });
        options.addEntry((AbstractConfigListEntry)btb.build());
    }

    private static void addFloatField(SneakUtilsConfig config, SneakUtilsConfig defConfig, Field field, ConfigCategory options, ConfigEntryBuilder entryBuilder) {
        float defValue;
        float value;
        try {
            value = field.getFloat(config);
            defValue = field.getFloat(defConfig);
        }
        catch (Exception ex) {
            logger.error("Could not get float from config class.", (Throwable)ex);
            return;
        }
        String key = field.getName();
        FloatFieldBuilder ffb = entryBuilder.startFloatField((class_2561)class_2561.method_43471((String)("option.sneakutils." + key)), value);
        ffb.setTooltip(new class_2561[]{class_2561.method_43471((String)("option.sneakutils.tooltip." + key))});
        ffb.setDefaultValue(defValue);
        ffb.setSaveConsumer(newValue -> {
            try {
                field.setFloat(config, newValue.floatValue());
            }
            catch (Exception ex) {
                logger.error("Could not set float to config class.", (Throwable)ex);
            }
        });
        if (field.isAnnotationPresent(ConfigFloatBounds.class)) {
            ConfigFloatBounds annotation = field.getAnnotation(ConfigFloatBounds.class);
            ffb.setMin(annotation.min());
            ffb.setMax(annotation.max());
        }
        options.addEntry((AbstractConfigListEntry)ffb.build());
    }

    private static void addIntField(SneakUtilsConfig config, SneakUtilsConfig defConfig, Field field, ConfigCategory options, ConfigEntryBuilder entryBuilder) {
        int defValue;
        int value;
        try {
            value = field.getInt(config);
            defValue = field.getInt(defConfig);
        }
        catch (Exception ex) {
            logger.error("Could not get int from config class.", (Throwable)ex);
            return;
        }
        String key = field.getName();
        IntFieldBuilder ifb = entryBuilder.startIntField((class_2561)class_2561.method_43471((String)("option.sneakutils." + key)), value);
        ifb.setTooltip(new class_2561[]{class_2561.method_43471((String)("option.sneakutils.tooltip." + key))});
        ifb.setDefaultValue(defValue);
        ifb.setSaveConsumer(newValue -> {
            try {
                field.setInt(config, (int)newValue);
            }
            catch (Exception ex) {
                logger.error("Could not set int to config class.", (Throwable)ex);
            }
        });
        if (field.isAnnotationPresent(ConfigIntBounds.class)) {
            ConfigIntBounds annotation = field.getAnnotation(ConfigIntBounds.class);
            ifb.setMin((int)annotation.min());
            ifb.setMax((int)annotation.max());
        }
        options.addEntry((AbstractConfigListEntry)ifb.build());
    }

    private static void addLongField(SneakUtilsConfig config, SneakUtilsConfig defConfig, Field field, ConfigCategory options, ConfigEntryBuilder entryBuilder) {
        long defValue;
        long value;
        try {
            value = field.getLong(config);
            defValue = field.getLong(defConfig);
        }
        catch (Exception ex) {
            logger.error("Could not get long from config class.", (Throwable)ex);
            return;
        }
        String key = field.getName();
        LongFieldBuilder lfb = entryBuilder.startLongField((class_2561)class_2561.method_43471((String)("option.sneakutils." + key)), value);
        lfb.setTooltip(new class_2561[]{class_2561.method_43471((String)("option.sneakutils.tooltip." + key))});
        lfb.setDefaultValue(defValue);
        lfb.setSaveConsumer(newValue -> {
            try {
                field.setLong(config, (long)newValue);
            }
            catch (Exception ex) {
                logger.error("Could not set long to config class.", (Throwable)ex);
            }
        });
        if (field.isAnnotationPresent(ConfigIntBounds.class)) {
            ConfigIntBounds annotation = field.getAnnotation(ConfigIntBounds.class);
            lfb.setMin(annotation.min());
            lfb.setMax(annotation.max());
        }
        options.addEntry((AbstractConfigListEntry)lfb.build());
    }

    private static void addEnumField(SneakUtilsConfig config, SneakUtilsConfig defConfig, Field field, ConfigCategory options, ConfigEntryBuilder entryBuilder) {
        Enum defValue;
        Enum value;
        try {
            value = (Enum)field.get(config);
            defValue = (Enum)field.get(defConfig);
        }
        catch (Exception ex) {
            logger.error("Could not get enum from config class.", (Throwable)ex);
            return;
        }
        String key = field.getName();
        String enumClassName = value.getClass().getSimpleName();
        String fieldKeyPrefix = "enum.sneakutils." + enumClassName + ".";
        List<Enum> constants = Arrays.asList((Enum[])field.getType().getEnumConstants());
        int constantCount = constants.size();
        List<String> enumDisplayNames = Arrays.asList(new String[constantCount]);
        class_2477 language = class_2477.method_10517();
        for (int i = 0; i < constantCount; ++i) {
            Enum constant = constants.get(i);
            String constantName = constant.toString();
            String constantDisplayName = language.method_48307(fieldKeyPrefix + constantName);
            if (constantDisplayName.equals(key)) {
                constantDisplayName = constantName;
            }
            enumDisplayNames.set(i, constantDisplayName);
        }
        DropdownMenuBuilder dmb = entryBuilder.startDropdownMenu((class_2561)class_2561.method_43471((String)("option.sneakutils." + key)), DropdownMenuBuilder.TopCellElementBuilder.of((Object)enumDisplayNames.get(constants.indexOf(value)), str -> enumDisplayNames.contains(str) ? str : null));
        dmb.setTooltip(new class_2561[]{class_2561.method_43471((String)("option.sneakutils.tooltip." + key))});
        dmb.setDefaultValue(() -> (String)enumDisplayNames.get(constants.indexOf(defValue)));
        dmb.setSelections(enumDisplayNames);
        dmb.setSaveConsumer(newValue -> {
            try {
                field.set(config, constants.get(enumDisplayNames.indexOf(newValue)));
            }
            catch (Exception ex) {
                logger.error("Could not set enum to config class.", (Throwable)ex);
            }
        });
        options.addEntry((AbstractConfigListEntry)dmb.build());
    }
}

