/*
 * Decompiled with CFR 0.152.
 */
package com.thegameratort.sneakutils.mixin;

import com.thegameratort.sneakutils.SneakUtils;
import com.thegameratort.sneakutils.config.CameraLerpMode;
import com.thegameratort.sneakutils.config.SneakUtilsConfig;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class CameraMixin {
    @Shadow
    private class_1297 field_18711;
    @Shadow
    private float field_18721;
    @Shadow
    private float field_18722;
    private class_9779 renderTickCounter;
    private float lerpTime;
    private float lerpStartCameraY;
    private float lerpEndCameraY;
    private float lerpDuration;
    private boolean isLerping;

    @Inject(method={"<init>()V"}, at={@At(value="TAIL")})
    private void init_hook(CallbackInfo ci) {
        this.renderTickCounter = class_310.method_1551().method_61966();
        this.isLerping = false;
    }

    @Redirect(method={"update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerp(FFF)F", ordinal=1))
    private float cameraHeightLerp_hook(float delta, float start, float end) {
        SneakUtilsConfig config = SneakUtils.getConfig();
        if (config.cameraLerpMode == CameraLerpMode.INSTANT) {
            return end;
        }
        this.updateLerp(this.renderTickCounter.method_60636());
        return this.field_18721;
    }

    @Overwrite
    public void method_19317() {
        if (this.field_18711 != null) {
            SneakUtilsConfig config = SneakUtils.getConfig();
            float eyeHeight = this.field_18711.method_5751();
            if (config.cameraLerpMode == CameraLerpMode.INSTANT) {
                this.field_18721 = eyeHeight;
                this.field_18722 = eyeHeight;
                return;
            }
            this.field_18722 = this.field_18721;
            if (eyeHeight != this.lerpEndCameraY) {
                if (!this.isLerping) {
                    this.lerpDuration = config.cameraLerpDuration;
                    this.isLerping = true;
                }
                this.lerpStartCameraY = this.field_18721;
                this.lerpEndCameraY = eyeHeight;
                this.lerpTime = 0.0f;
            }
        }
    }

    private void updateLerp(float deltaTime) {
        if (this.isLerping) {
            SneakUtilsConfig config = SneakUtils.getConfig();
            if (this.lerpTime >= this.lerpDuration) {
                this.isLerping = false;
                this.field_18721 = this.lerpEndCameraY;
                return;
            }
            float factor = this.resolveFactor(config.cameraLerpMode, this.lerpTime / this.lerpDuration);
            this.field_18721 = class_3532.method_16439((float)factor, (float)this.lerpStartCameraY, (float)this.lerpEndCameraY);
            this.lerpTime += deltaTime;
        }
    }

    private float resolveFactor(CameraLerpMode lerpMode, float factor) {
        return switch (lerpMode) {
            default -> factor;
            case CameraLerpMode.SMOOTH_STEP -> CameraMixin.smoothStep(factor);
            case CameraLerpMode.SMOOTHER_STEP -> CameraMixin.smootherStep(factor);
            case CameraLerpMode.DEFAULT_STEP -> CameraMixin.defaultStep(factor);
        };
    }

    private static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private static float smootherStep(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    private static float defaultStep(float x) {
        double b = 16.0;
        double n = -Math.exp(-(16.0 * (double)x)) + 1.0;
        double m = 1.0 - Math.exp(-16.0);
        return (float)(n / m);
    }
}

