/*
 * Decompiled with CFR 0.152.
 */
package com.thegameratort.sneakutils.mixin.compat;

import com.thegameratort.sneakutils.SneakUtils;
import com.thegameratort.sneakutils.config.SneakUtilsConfigManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"com.replaymod.replay.ReplayHandler"}, remap=false)
public class ReplayModMixin {
    private static final Logger logger = LogManager.getLogger();

    @Inject(method={"setup"}, at={@At(value="HEAD")})
    @Dynamic
    private void setup_hook(CallbackInfo ci) {
        String serverName;
        boolean isSingleplayer;
        try {
            Object replayMetadata = this.getReplayMetadata(this.getReplayFile());
            isSingleplayer = (Boolean)this.getReplayMetadataField(replayMetadata, "isSingleplayer");
            serverName = (String)this.getReplayMetadataField(replayMetadata, "getServerName");
        }
        catch (Exception ex) {
            return;
        }
        String folder = isSingleplayer ? "worlds" : "servers";
        SneakUtilsConfigManager configManager = SneakUtils.getConfigManager();
        configManager.loadConfig(folder, serverName);
        configManager.setCurrentWorldName(serverName);
    }

    private Object getReplayFile() throws Exception {
        Object replayFile;
        try {
            Field replayFileField = this.getClass().getDeclaredField("replayFile");
            replayFile = replayFileField.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            logger.error("Could not get the replay file", (Throwable)ex);
            throw new Exception();
        }
        return replayFile;
    }

    private Object getReplayMetadata(Object replayFile) throws Exception {
        Object replayMetadata;
        try {
            Method getMetadataMethod = replayFile.getClass().getMethod("getMetaData", new Class[0]);
            replayMetadata = getMetadataMethod.invoke(replayFile, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            logger.error("Could not get the replay file metadata", (Throwable)ex);
            throw new Exception();
        }
        return replayMetadata;
    }

    private <T> T getReplayMetadataField(Object replayMetadata, String methodName) throws Exception {
        Object value;
        Method method;
        try {
            method = replayMetadata.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Could not find method ReplayMetaData." + methodName + "()", (Throwable)ex);
            throw new Exception();
        }
        try {
            value = method.invoke(replayMetadata, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            logger.error("Could not invoke method ReplayMetaData." + methodName + "()", (Throwable)ex);
            throw new Exception();
        }
        return (T)value;
    }
}

