/*
 * Decompiled with CFR 0.152.
 */
package com.eirmax.elytraswaperplus.utils;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class ArmorHelperUtil {
    public static int getBestChestplate(Minecraft client) {
        int bestSlot = -1;
        int highestScore = -1;
        for (int i = 0; i < client.player.getInventory().getContainerSize(); ++i) {
            int score;
            ItemStack stack = client.player.getInventory().getItem(i);
            if (!ArmorHelperUtil.isChestplate(stack, client) || stack.is(Items.ELYTRA) || (score = ArmorHelperUtil.calculateScore(stack)) <= highestScore) continue;
            highestScore = score;
            bestSlot = i;
        }
        return bestSlot;
    }

    public static boolean isChestplate(ItemStack stack, Minecraft client) {
        return client.player.getEquipmentSlotForItem(stack) == EquipmentSlot.CHEST;
    }

    public static int calculateScore(ItemStack stack) {
        AtomicInteger score = new AtomicInteger();
        if (stack.getItem() == Items.NETHERITE_CHESTPLATE) {
            score.addAndGet(6);
        } else if (stack.getItem() == Items.DIAMOND_CHESTPLATE) {
            score.addAndGet(5);
        } else if (stack.getItem() == Items.IRON_CHESTPLATE) {
            score.addAndGet(4);
        } else if (stack.getItem() == Items.CHAINMAIL_CHESTPLATE) {
            score.addAndGet(3);
        } else if (stack.getItem() == Items.GOLDEN_CHESTPLATE) {
            score.addAndGet(2);
        } else if (stack.getItem() == Items.LEATHER_CHESTPLATE) {
            score.addAndGet(1);
        }
        if (stack.isEnchanted()) {
            score.addAndGet(1);
        }
        HashMap<ResourceKey, Integer> enchantmentPoints = new HashMap<ResourceKey, Integer>();
        enchantmentPoints.put(Enchantments.PROTECTION, 7);
        enchantmentPoints.put(Enchantments.UNBREAKING, 6);
        enchantmentPoints.put(Enchantments.MENDING, 5);
        enchantmentPoints.put(Enchantments.PROJECTILE_PROTECTION, 2);
        enchantmentPoints.put(Enchantments.BLAST_PROTECTION, 1);
        enchantmentPoints.put(Enchantments.FIRE_PROTECTION, 3);
        enchantmentPoints.put(Enchantments.THORNS, 4);
        stack.getEnchantments().entrySet().forEach(e -> {
            Enchantment enchantment = (Enchantment)((Holder)e.getKey()).value();
            int level = e.getValue();
            Integer points = (Integer)enchantmentPoints.get(enchantment);
            if (points != null) {
                score.addAndGet(points * level);
            }
        });
        return score.get();
    }
}

