/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.util.Util;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Version;
import java.io.IOException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AddonLoader {
    private final Skonic plugin;
    private final PluginManager pluginManager;
    private final Plugin skriptPlugin;
    private SkriptAddon addon;

    public AddonLoader(Skonic plugin) {
        this.plugin = plugin;
        this.pluginManager = plugin.getServer().getPluginManager();
        this.skriptPlugin = this.pluginManager.getPlugin("Skript");
    }

    boolean canLoadPlugin() {
        if (this.skriptPlugin == null) {
            Util.log("&cDependency Skript was not found, plugin disabling.", new Object[0]);
            return false;
        }
        if (!this.skriptPlugin.isEnabled()) {
            Util.log("&cDependency Skript is not enabled, plugin disabling.", new Object[0]);
            Util.log("&cThis could mean SkBee is being forced to load before Skript.", new Object[0]);
            return false;
        }
        if (!Skript.isAcceptRegistrations()) {
            Util.log("&cSkript is no longer accepting registrations, addons can no longer be loaded!", new Object[0]);
            Util.log("&cNo clue how this could happen.", new Object[0]);
            Util.log("&cSeems a plugin is delaying &9Skonic loading, which is after Skript stops accepting registrations.", new Object[0]);
            return false;
        }
        Version version = new Version(Skonic.EARLIEST_VERSION);
        if (!Skript.isRunningMinecraft((Version)version)) {
            Util.log("&cYour server version &7'&bMC %s&7'&c is not supported, only &7'&bMC %s+&7'&c is supported!", Skript.getMinecraftVersion(), version);
            return false;
        }
        this.loadSkriptElements();
        return true;
    }

    private void loadSkriptElements() {
        this.addon = Skript.registerAddon((JavaPlugin)this.plugin);
        this.addon.setLanguageFileDirectory("lang");
        int[] elementCountBefore = Util.getElementCount();
        this.loadCitizenElements();
        this.loadHeadElements();
        this.loadOtherItemElements();
        this.loadSkinElements();
        this.loadOtherClasses();
        int[] elementCountAfter = Util.getElementCount();
        int[] finish = new int[elementCountBefore.length];
        int total = 0;
        for (int i = 0; i < elementCountBefore.length; ++i) {
            finish[i] = elementCountAfter[i] - elementCountBefore[i];
            total += finish[i];
        }
        String[] elementNames = new String[]{"event", "effect", "expression", "condition", "section"};
        Util.log("Loaded (%s) elements:", total);
        for (int i = 0; i < finish.length; ++i) {
            Util.log(" - %s %s%s", finish[i], elementNames[i], finish[i] == 1 ? "" : "s");
        }
    }

    private void loadCitizenElements() {
        if (this.pluginManager.isPluginEnabled("Citizens")) {
            try {
                this.addon.loadClasses("au.nagasonic.skonic.elements.citizens", new String[0]);
                Util.logLoading("&6Citizen elements &ahave successfully loaded", new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.loadOtherCitizenClasses();
            this.loadForcefieldElements();
            this.loadHitboxElements();
        } else {
            Util.logLoading("&6Citizen elements have been disabled: &cMissing Citizen Plugin", new Object[0]);
        }
    }

    private void loadForcefieldElements() {
        Version skriptVersion = Skript.getVersion();
        if (skriptVersion.isLargerThan(new Version(new int[]{2, 9, 5}))) {
            try {
                this.addon.loadClasses("au.nagasonic.skonic.elements.forcefield", new String[0]);
                Util.logLoading("&6Citizen Forcefield elements &ahave successfully loaded", new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.loadForcefieldClass();
        } else {
            Util.logLoading("&6Citizen Forcefield elements have been disabled: &cOutdated Skript Version: Requires at least 2.10.0", new Object[0]);
        }
    }

    private void loadForcefieldClass() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.classes.citizens.forcefield", new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadHitboxElements() {
        Version skriptVersion = Skript.getVersion();
        if (skriptVersion.isLargerThan(new Version(new int[]{2, 9, 5}))) {
            try {
                this.addon.loadClasses("au.nagasonic.skonic.elements.hitbox", new String[0]);
                Util.logLoading("&6Citizen Hitbox elements &ahave successfully loaded", new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.loadHitboxClass();
        } else {
            Util.logLoading("&6Citizen Forcefield elements have been disabled: &cOutdated Skript Version: Requires at least 2.10.0", new Object[0]);
        }
    }

    private void loadHitboxClass() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.classes.citizens.hitbox", new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadOtherCitizenClasses() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.classes.citizens.other", new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadHeadElements() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.elements.items.heads", new String[0]);
            Util.logLoading("&6Head elements &ahave successfully loaded", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadOtherItemElements() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.elements.items.other", new String[0]);
            Util.logLoading("&6Other Item elements &ahave successfully loaded", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadSkinElements() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.elements.skins", new String[0]);
            Util.logLoading("&6Skin elements &ahave successfully loaded", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadOtherClasses() {
        try {
            this.addon.loadClasses("au.nagasonic.skonic.classes.other", new String[0]);
            Util.logLoading("&aLoaded all Class Types successfully", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

