/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.classes.citizens.other;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.EnumUtils;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.EntityPoseTrait;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

public class CitizenTypes {
    static {
        Classes.registerClass((ClassInfo)new ClassInfo(NPC.class, "npc").user(new String[]{"npcs?"}).name("Citizens NPC").description(new String[]{"Represents a Citizens NPC."}).examples(new String[]{"last spawned npc", "delete last spawned npc"}).since("1.0.0").requiredPlugins(new String[]{"Citizens"}).parser((Parser)new Parser<NPC>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            @NotNull
            public String toString(NPC npc, int flags) {
                return "citizen with id " + npc.getId();
            }

            @NotNull
            public String toVariableNameString(NPC npc) {
                return "citizen:" + npc.getId();
            }
        }).changer((Changer)new Changer<NPC>(){

            @Nullable
            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    return (Class[])CollectionUtils.array((Object[])new Class[0]);
                }
                return null;
            }

            public void change(NPC[] what, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    for (NPC npc : what) {
                        npc.destroy();
                    }
                }
            }
        }));
        final EnumUtils SPAWN_REASON_ENUM = new EnumUtils(SpawnReason.class, "npcspawnreasons");
        Classes.registerClass((ClassInfo)new ClassInfo(SpawnReason.class, "npcspawnreason").user(new String[]{"npc ?spawn ?reasons?"}).name("Citizens Spawn Reason").description(new String[]{"Represents the reasons a Citizen will spawn."}).usage(new String[]{SPAWN_REASON_ENUM.getAllNames().replace("spawnreasons.", "")}).examples(new String[]{"if event-npcspawnreason = chunk load:"}).since("1.1").requiredPlugins(new String[]{"Citizens"}).parser((Parser)new Parser<SpawnReason>(){

            @Nullable
            public SpawnReason parse(String string, ParseContext context) {
                return (SpawnReason)SPAWN_REASON_ENUM.parse(string);
            }

            @NotNull
            public String toString(SpawnReason spawnReason, int flags) {
                return SPAWN_REASON_ENUM.toString((Enum)spawnReason, flags);
            }

            @NotNull
            public String toVariableNameString(SpawnReason spawnReason) {
                return "npcspawnreason:" + this.toString(spawnReason, 0);
            }
        }).serializer((Serializer)new EnumSerializer(SpawnReason.class)));
        final EnumUtils DESPAWN_REASON_ENUM = new EnumUtils(DespawnReason.class, "npcdespawnreasons");
        Classes.registerClass((ClassInfo)new ClassInfo(DespawnReason.class, "npcdespawnreason").user(new String[]{"npc ?despawn ?reasons?"}).name("Citizens Despawn Reason").description(new String[]{"Represents the reasons a Citizen will despawn."}).usage(new String[]{DESPAWN_REASON_ENUM.getAllNames().replace("despawnreasons.", "")}).examples(new String[]{"if event-npcdespawnreason = chunk unload:"}).requiredPlugins(new String[]{"Citizens"}).since("1.1").parser((Parser)new Parser<DespawnReason>(){

            @Nullable
            public DespawnReason parse(String s, ParseContext context) {
                return (DespawnReason)DESPAWN_REASON_ENUM.parse(s);
            }

            @NotNull
            public String toString(DespawnReason despawnReason, int flags) {
                return DESPAWN_REASON_ENUM.toString((Enum)despawnReason, flags);
            }

            @NotNull
            public String toVariableNameString(DespawnReason despawnReason) {
                return "npcdespawnreason:" + this.toString(despawnReason, 0);
            }
        }).serializer((Serializer)new EnumSerializer(DespawnReason.class)));
        final EnumUtils ENTITY_POSE_ENUM = new EnumUtils(EntityPoseTrait.EntityPose.class, "npcentityposes");
        Classes.registerClass((ClassInfo)new ClassInfo(EntityPoseTrait.EntityPose.class, "npcentitypose").user(new String[]{"npc ?entity ?poses?"}).name("Citizens Entity Pose").description(new String[]{"Represents the 'pose' of a Citizens NPC.", "Essentially different animations, depending on the entity type of the NPC."}).usage(new String[]{ENTITY_POSE_ENUM.getAllNames()}).examples(new String[]{"if entity pose of {_npc} is crouch:"}).requiredPlugins(new String[]{"Citizens"}).since("1.2.1").parser((Parser)new Parser<EntityPoseTrait.EntityPose>(){

            @Nullable
            public EntityPoseTrait.EntityPose parse(String s, ParseContext context) {
                return (EntityPoseTrait.EntityPose)ENTITY_POSE_ENUM.parse(s);
            }

            @NotNull
            public String toString(EntityPoseTrait.EntityPose o, int flags) {
                return ENTITY_POSE_ENUM.toString((Enum)o, flags);
            }

            @NotNull
            public String toVariableNameString(EntityPoseTrait.EntityPose o) {
                return "npcentitypose:" + this.toString(o, 0);
            }
        }).serializer((Serializer)new EnumSerializer(EntityPoseTrait.EntityPose.class)));
        Converters.registerConverter(NPC.class, Entity.class, NPC::getEntity);
    }
}

