/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Can Load Chunks")
@Description(value={"Whether a Citizens NPC can load chunks."})
@Since(value={"1.2.1-b1"})
@Examples(value={""})
@RequiredPlugins(value={"Citizens"})
public class CondCitizenCanLoadChunks
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event event) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null || !(this.pattern == 0 ? (Boolean)npc.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)false) == false : (Boolean)npc.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)false) == true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "Citizen " + this.npcExpr.toString(event, debug) + " can load chunks";
        }
        return "Citizen " + this.npcExpr.toString(event, debug) + " can't load chunks";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenCanLoadChunks.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (can|is able to) load chunk[s]", "(citizen|npc)[s] %npcs% (can('t|not| not)|is('nt| not) able to|is unable to) load chunk[s]"});
    }
}

