/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Aggressive")
@Description(value={"Returns the bool of whether the citizen is aggressive."})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"if npc with id 3 is aggressive:", "\tbroadcast \"Npc is Aggressive\""})
@Since(value={"1.2"})
public class CondCitizenIsAggressive
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null || !(this.pattern == 0 ? (Boolean)npc.data().get(NPC.Metadata.AGGRESSIVE, (Object)false) == false : (Boolean)npc.data().get(NPC.Metadata.AGGRESSIVE, (Object)true) == true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "Citizen " + this.npcExpr.toString(e, b) + " aren't aggressive.";
    }

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = pattern;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsAggressive.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are) aggressive", "(citizen|npc)[s] %npcs% (is(n't| not)|are(n't| not)) aggressive", "(citizen|npc)[s] %npcs% (is|are) passive"});
    }
}

