/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Collidable")
@Description(value={"Whether a Citizens NPC is collidable. By entities or fluids."})
@Examples(value={""})
@Since(value={"1.2.1-b1"})
@RequiredPlugins(value={"Citizens"})
public class CondCitizenIsCollidable
extends Condition {
    private Expression<NPC> npcExpr;
    private boolean f;
    private int pattern;

    public boolean check(Event event) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs == null) {
            return false;
        }
        for (NPC npc : npcs) {
            NPC.Metadata metadata;
            if (npcs == null) {
                return false;
            }
            NPC.Metadata metadata2 = metadata = this.f ? NPC.Metadata.FLUID_PUSHABLE : NPC.Metadata.COLLIDABLE;
            if (!(this.pattern == 0 ? (Boolean)npc.data().get(metadata, (Object)false) == false : (Boolean)npc.data().get(metadata, (Object)true) == true)) continue;
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "Citizen " + this.npcExpr.toString(event, debug) + " are collidable";
        }
        return "Citizen " + this.npcExpr.toString(event, debug) + " aren't collidable";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = matchedPattern;
        this.f = parseResult.hasTag("f");
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsCollidable.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are) (collidable|pushable) [f:(with|by) fluids]", "(citizen|npc)[s] %npcs% (are(n't| not)|is(n't| not)) (collidable|pushable) [f:(with|by) fluids]"});
    }
}

