/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Navigating")
@Description(value={"Returns the bool of whether the citizen is pathfinding."})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"if npc with id 1 is navigating:", "\tmake citizen npc with id 1 attack player"})
@Since(value={"1.0.7, 1.2.3(location)"})
public class CondCitizenIsNavigating
extends Condition {
    private Expression<NPC> npcExpr;
    private Expression<Location> locExpr;
    private int pattern;
    private boolean l;

    public boolean check(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                Location loc;
                if (npc == null || !(this.pattern == 0 ? (this.l ? (loc = (Location)this.locExpr.getSingle(e)) != null && npc.getNavigator().getTargetAsLocation() == loc : !npc.getNavigator().isNavigating()) : (this.l ? (loc = (Location)this.locExpr.getSingle(e)) != null && npc.getNavigator().getTargetAsLocation() != loc : npc.getNavigator().isNavigating()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "Citizen " + this.npcExpr.toString(e, b) + " is navigating.";
    }

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.locExpr = exprs[1];
        this.l = parseResult.hasTag("l");
        this.pattern = pattern;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsNavigating.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are) navigating [l:to %location%]", "(citizen|npc)[s] %npcs% (is(n't| not)|are(n't| not)) navigating [l:to %location%]"});
    }
}

