/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Is Paused")
@Description(value={"Whether the navigator of a Citizens NPC is paused."})
@Since(value={"1.2"})
@Examples(value={"if all citizens are paused:", "\tunpause all citizens"})
@RequiredPlugins(value={"Citizens"})
public class CondCitizenIsPaused
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event event) {
        if (this.npcExpr != null) {
            NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
            if (npcs != null) {
                if (this.pattern == 0) {
                    for (NPC npc : npcs) {
                        if (npc.getNavigator().isPaused()) continue;
                        return false;
                    }
                } else {
                    for (NPC npc : npcs) {
                        if (!npc.getNavigator().isPaused()) continue;
                        return false;
                    }
                }
                return true;
            }
            Skonic.log(Level.SEVERE, "No npcs were specified.");
        } else {
            Skonic.log(Level.SEVERE, "No npcs were specified.");
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return this.npcExpr.toString(event, debug) + " is paused";
        }
        return this.npcExpr.toString(event, debug) + " isn't paused";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenIsPaused.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (is|are) paused", "(citizen|npc)[s] %npcs% (isn't|is not|aren't|are not) paused"});
    }
}

