/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.conditions;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Uses Minecraft AI")
@Description(value={"Whether a Citizens NPC is using Minecraft's built-in AI or Citizens AI."})
@Since(value={"1.2.3"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={""})
public class CondCitizenUsesMCAI
extends Condition {
    private Expression<NPC> npcExpr;
    private int pattern;

    public boolean check(Event event) {
        if (this.npcExpr == null) {
            Skonic.log(Level.SEVERE, "NPC is null");
            return false;
        }
        NPC[] npcs = (NPC[])this.npcExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc == null || !(this.pattern == 0 ? !npc.useMinecraftAI() : npc.useMinecraftAI())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return this.npcExpr.toString(event, b) + " uses minecraft ai";
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = i;
        return true;
    }

    static {
        Skript.registerCondition(CondCitizenUsesMCAI.class, (String[])new String[]{"(citizen|npc)[s] %npcs% (use[s]|(is|are) using) (minecraft|normal) (ai|AI)", "(citizen|npc)[s] %npcs% (is(n't| not) using|are(n't| not) using|do(n't| not) use) (minecraft|normal) (ai|AI)"});
    }
}

