/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.skins.Skin;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Name(value="Set Citizen Skin - Skin")
@Description(value={"Sets the skin of the npc to the given skin."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.7"})
@Examples(value={"set skin of last spawned npc to player's skin", "change npc with id 2's skin to player's skin"})
public class EffChangeCitizenSkin
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private Expression<Skin> skinExpr;

    protected void execute(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc != null) continue;
                Skript.error((String)("NPC " + npc.toString() + " is null"));
            }
            Skin skin = (Skin)this.skinExpr.getSingle(e);
            if (skin != null) {
                String signature;
                String uuid;
                String value = skin.getTexture();
                if (value == null) {
                    Skript.error((String)"Specified skin's value is null");
                }
                if ((uuid = String.valueOf(skin.getUUID())) == null) {
                    Skript.error((String)"Specified skin's uuid is null");
                }
                if ((signature = skin.getSignature()) == null) {
                    Skript.error((String)"Specified skin's signature is null");
                }
                for (NPC npc : npcs) {
                    SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                    Bukkit.getScheduler().runTask((Plugin)Skonic.getInstance(), () -> {
                        try {
                            trait.setSkinPersistent(uuid, signature, value);
                        }
                        catch (IllegalArgumentException err) {
                            Bukkit.getLogger().log(Level.SEVERE, "There was an error setting the skin of citizen with id " + npc.getId() + err.getMessage());
                        }
                    });
                }
            } else {
                Skript.error((String)"Specified skin is null");
            }
        } else {
            Skript.error((String)"There are no citizens to change the skin of.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "change skin of citizens " + this.npcExpr.toString(e, debug) + " to skin " + this.skinExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.skinExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeCitizenSkin.class, (String[])new String[]{"(change|set) (npc|citizen)[s] %npcs%['s] skin to %skin%", "(change|set) skin of (npc|citizen)[s] %npcs% to %skin%"});
    }
}

