/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.util.SkinUtils;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Name(value="Set Citizen Skin - URL")
@Description(value={"Sets the citizen with the id specified to the skin linked on the url."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.0"})
@Examples(value={"set skin of last spawned npc to url \"https://www.minecraftskins.com/uploads/skins/2024/12/12/--*ginger-bread-man*----tcer3--22929673.png?v695\""})
public class EffChangeCitizenSkinURL
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private Expression<String> urlExpr;

    protected void execute(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc != null) continue;
                Skript.error((String)("NPC " + npc.toString() + " is null"));
            }
            String url = (String)this.urlExpr.getSingle(e);
            if (url != null) {
                try {
                    URL Url = new URL(url);
                    String urlString = Url.toString();
                    if (!urlString.contains("https://www.minecraftskins.com") || urlString.contains("http://textures.minecraft.net")) {
                        Skript.error((String)"Specified URL is not a valid URL. Please use a url from \"https://www.minecraftskins.com\" or \"http://textures.minecraft.net\"", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    }
                }
                catch (MalformedURLException ex) {
                    Skript.error((String)"Specified 'URL' is not a valid URL");
                    throw new RuntimeException(ex);
                }
                JsonObject data = null;
                try {
                    data = SkinUtils.generateFromURL(url, false);
                }
                catch (InterruptedException ex) {
                    Skript.error((String)("There was an error in retrieving the skin from " + url), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    Skript.error((String)("There was an error in retrieving the skin from " + url), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    throw new RuntimeException(ex);
                }
                String uuid = data.get("uuid").getAsString();
                JsonObject texture = data.get("texture").getAsJsonObject();
                String textureEncoded = texture.get("value").getAsString();
                String signature = texture.get("signature").getAsString();
                for (NPC npc : npcs) {
                    SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                    Bukkit.getScheduler().runTask((Plugin)Skonic.getInstance(), () -> {
                        try {
                            trait.setSkinPersistent(uuid, signature, textureEncoded);
                            Skonic.log(Level.INFO, "Set skin of citizen with id " + npc.getId() + " to " + url);
                        }
                        catch (IllegalArgumentException err) {
                            Skonic.log(Level.SEVERE, "There was an error setting the skin of citizen with id " + npc.getId() + " to " + url + err.getMessage());
                        }
                    });
                }
            } else {
                Skript.error((String)"Specified URL is null");
            }
        } else {
            Skript.error((String)"Specified ID is null", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "change skin of citizens " + this.npcExpr.toString(e, debug) + " to url " + this.urlExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.urlExpr = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeCitizenSkinURL.class, (String[])new String[]{"(change|set) (npc|citizen)[s] %npcs%['s] skin to url %string%", "(change|set) skin of (npc|citizen)[s] %npcs% to url %string%"});
    }
}

