/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Aggressive")
@Description(value={"Make a Citizens NPC aggressive."})
@Since(value={"1.1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make npc with id 1 aggressive"})
public class EffCitizenAggressive
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private int pattern;

    protected void execute(Event event) {
        if (this.npcExpr != null) {
            NPC npc = (NPC)this.npcExpr.getSingle(event);
            if (npc != null) {
                if (this.pattern == 0) {
                    npc.data().set(NPC.Metadata.AGGRESSIVE, (Object)true);
                    NMS.setAggressive((Entity)npc.getEntity(), (boolean)true);
                } else if (this.pattern == 1) {
                    npc.data().set(NPC.Metadata.AGGRESSIVE, (Object)false);
                    NMS.setAggressive((Entity)npc.getEntity(), (boolean)false);
                } else {
                    Skonic.log(Level.SEVERE, "How? That shouldn't be possible.");
                }
            } else {
                Skonic.log(Level.SEVERE, "Npc cannot be null");
            }
        } else {
            Skonic.log(Level.SEVERE, "NPC expression can't be null.");
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        if (this.pattern == 0) {
            return "make " + this.npcExpr.toString(event, b) + " aggressive";
        }
        return "make " + this.npcExpr.toString(event, b) + " passive";
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.pattern = i;
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenAggressive.class, (String[])new String[]{"make %npc% aggressive", "make %npc% passive"});
    }
}

