/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import au.nagasonic.skonic.elements.util.Util;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Attack")
@Description(value={"Make a citizen attack an entityWill also stop any pathfinding."})
@Since(value={"1.0.0"})
@Examples(value={"make npc all citizens attack player", "wait 5 seconds", "stop all citizens from attacking player"})
@RequiredPlugins(value={"Citizens"})
public class EffCitizenAttack
extends AsyncEffect {
    private int patterns;
    private Expression<NPC> npcExpr;
    private Expression<Entity> victim;

    protected void execute(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc != null) {
                    if (this.patterns == 0) {
                        if (!npc.isSpawned()) continue;
                        npc.getNavigator().setTarget((Entity)this.victim.getSingle(e), true);
                        Util.log("Made npc: " + npc.toString() + "attack player", new Object[0]);
                        continue;
                    }
                    if (this.patterns == 1) {
                        if (!npc.isSpawned()) continue;
                        npc.getNavigator().setPaused(true);
                        continue;
                    }
                    Skonic.log(Level.SEVERE, "Pattern was entered incorrectly.");
                    continue;
                }
                Skonic.log(Level.SEVERE, "There is no npc " + npc.toString());
            }
        } else {
            Skonic.log(Level.SEVERE, "The Specified ID is null");
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.patterns == 0) {
            return "make citizens " + this.npcExpr.toString(e, debug) + " attack entity " + this.victim.toString(e, debug);
        }
        return "make citizens " + this.npcExpr.toString(e, debug) + " stop attacking entity " + this.victim.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.patterns = matchedPattern;
        this.npcExpr = exprs[0];
        this.victim = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenAttack.class, (String[])new String[]{"make (npc|citizen) %npcs% (attack|fight) %entity%", "stop %npcs% from (attacking|fighting) %entity%"});
    }
}

