/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Collidable")
@Description(value={"Changes whether a Citizens NPC can be collided with by entities or fluids."})
@Since(value={"1.2.1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make npc with id 3 not pushable by fluids"})
public class EffCitizenCollidable
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private boolean not;
    private boolean f;

    protected void execute(Event event) {
        NPC npc = (NPC)this.npcExpr.getSingle(event);
        if (npc != null) {
            if (this.f) {
                npc.data().setPersistent(NPC.Metadata.FLUID_PUSHABLE, (Object)(!this.not ? 1 : 0));
            } else {
                npc.data().setPersistent(NPC.Metadata.COLLIDABLE, (Object)(!this.not ? 1 : 0));
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String f = this.f ? " by fluids" : "";
        String n = this.not ? " not" : "";
        return "make " + this.npcExpr.toString(event, debug) + n + " collidable" + f;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.not = parseResult.hasTag("not");
        this.f = parseResult.hasTag("f");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenCollidable.class, (String[])new String[]{"make %npc% [not:not] (collidable|pushable) [f:(with|by) fluids]"});
    }
}

