/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Flyable")
@Description(value={"Makes a Citizens NPC flyable.", "Some entity types are always flyable (e.g bat), therefore will always be flyable."})
@Since(value={"1.2.1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make npc with id 3 flyable", "wait 4 seconds", "make npc with id 3 unflyable"})
public class EffCitizenFlyable
extends Effect {
    private Expression<NPC> npcExpr;
    private boolean not;

    protected void execute(Event event) {
        NPC npc = (NPC)this.npcExpr.getSingle(event);
        if (npc != null) {
            npc.setFlyable(!this.not);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String n = this.not ? " un" : " ";
        return "make " + this.npcExpr.toString(event, debug) + n + "flyable";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.not = parseResult.hasTag("not");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenFlyable.class, (String[])new String[]{"make %npc% [not:not |not:un]flyable"});
    }
}

