/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Start/Stop Glowing")
@Description(value={"Makes a Citizens NPC start or stop glowing, with color."})
@Since(value={"1.2.2-b1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make all npcs start glowing with color red"})
public class EffCitizenGlow
extends AsyncEffect {
    private Expression<NPC> npcsExpr;
    private Expression<ChatColor> colorExpr;
    private boolean not;
    private boolean c;

    protected void execute(Event event) {
        NPC[] npcs = (NPC[])this.npcsExpr.getArray(event);
        if (npcs != null) {
            for (NPC npc : npcs) {
                ChatColor color;
                if (npc == null) continue;
                if (this.c && (color = (ChatColor)this.colorExpr.getSingle(event)) != null) {
                    ((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).setColor((ChatColor)this.colorExpr.getSingle(event));
                }
                npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)this.not);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String messsage = !this.not ? "make " + this.npcsExpr.toString(event, debug) + " stop glowing" : "make " + this.npcsExpr.toString(event, debug) + " start glowing";
        return messsage;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcsExpr = exprs[0];
        this.colorExpr = exprs[1];
        this.not = !parseResult.hasTag("stop");
        this.c = parseResult.hasTag("c");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenGlow.class, (String[])new String[]{"make %npcs% (start|:stop) glowing [c:[with colo[u]r] %-chatcolor%]", "(start|:stop) %npcs% [from] glowing [c:[with colo[u]r] %-chatcolor%]"});
    }
}

