/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Load Chunks")
@Description(value={"Changes whether a citizen will load chunks.", "Temporarily means that it won't continue after server is restarted."})
@Since(value={"1.2.1"})
@RequiredPlugins(value={"Citizens"})
@Examples(value={"make npc with id 4 able to load chunks"})
public class EffCitizenLoadChunks
extends AsyncEffect {
    private Expression<NPC> npcExpr;
    private boolean not;
    private boolean t;

    protected void execute(Event event) {
        NPC npc;
        if (this.npcExpr != null && (npc = (NPC)this.npcExpr.getSingle(event)) != null) {
            if (this.t) {
                npc.data().set(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)(!this.not ? 1 : 0));
            } else {
                npc.data().setPersistent(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)(!this.not ? 1 : 0));
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        String n = this.not ? " un" : " ";
        String t = this.t ? " temporarily" : "";
        return "make " + this.npcExpr.toString(event, debug) + n + "able to load chunks" + t;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        this.not = parseResult.hasTag("not");
        this.t = parseResult.hasTag("t");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenLoadChunks.class, (String[])new String[]{"make %npc% [not:un]able to load chunks [t:temporarily]"});
    }
}

