/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Use Minecraft AI")
@Description(value={"Changes whether a Citizens NPC uses Minecraft's built-in AI or Citizens AI."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.2.3"})
@Examples(value={""})
public class EffCitizenMinecraftAI
extends AsyncEffect {
    private Expression<NPC> npcsExpr;
    private int pattern;

    protected void execute(Event event) {
        NPC[] npcs;
        if (this.npcsExpr != null && (npcs = (NPC[])this.npcsExpr.getArray(event)) != null) {
            for (NPC npc : npcs) {
                if (this.pattern == 1) {
                    npc.setUseMinecraftAI(false);
                    continue;
                }
                npc.setUseMinecraftAI(true);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.npcsExpr.toString(event, debug) + (this.pattern == 0 ? " " : " not ") + "use minecraft ai";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcsExpr = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenMinecraftAI.class, (String[])new String[]{"(make|set) %npcs% [to] use (minecraft|normal) (ai|AI)", "(make|set) %npcs% [to] not use (minecraft|normal) (ai|AI)"});
    }
}

