/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Make Citizen Vulnerable")
@Description(value={"Changes whether a Citizens NPC can be attacked or not."})
@Examples(value={"on citizen damage:", "\tmake event-npc invulnerable", "\twait 5 seconds", "\tmake event-npc protected"})
@Since(value={"1.2"})
@RequiredPlugins(value={"Citizens"})
public class EffCitizenVulnerable
extends AsyncEffect {
    private Expression<NPC> npcsExpr;
    private int pattern;
    private boolean not;

    protected void execute(Event event) {
        NPC[] npcs;
        if (this.npcsExpr != null && (npcs = (NPC[])this.npcsExpr.getArray(event)) != null) {
            for (NPC npc : npcs) {
                if (npc == null) continue;
                if (this.pattern == 0) {
                    npc.setProtected(this.not);
                    continue;
                }
                npc.setProtected(!this.not);
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            return "make " + this.npcsExpr.toString(event, debug) + (this.not ? " invulnerable" : " vulnerable");
        }
        return "make " + this.npcsExpr.toString(event, debug) + (this.not ? " protected" : " unprotected");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcsExpr = exprs[0];
        this.pattern = matchedPattern;
        this.not = parseResult.hasTag("not");
        return true;
    }

    static {
        Skript.registerEffect(EffCitizenVulnerable.class, (String[])new String[]{"make (citizen|npc) %npcs% [not:in]vulnerable", "make (citizen|npc) %npcs% [not:un]protected"});
    }
}

