/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.effects;

import au.nagasonic.skonic.Skonic;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.logging.Level;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Delete Citizen")
@Description(value={"Destroy a citizen by id."})
@Since(value={"1.0.0, 1.2.2-b1 (multiple)"})
@Examples(value={"delete all npcs"})
@RequiredPlugins(value={"Citizens"})
public class EffDeleteCitizen
extends Effect {
    private Expression<NPC> npcExpr;

    protected void execute(Event e) {
        NPC[] npcs = (NPC[])this.npcExpr.getArray(e);
        if (npcs != null) {
            for (NPC npc : npcs) {
                if (npc.getOwningRegistry() != null) {
                    npc.destroy();
                    continue;
                }
                Skonic.log(Level.SEVERE, "The citizen has no Owning Registry");
            }
        } else {
            Skonic.log(Level.SEVERE, "There is no citizen " + npcs.toString());
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "delete citizens " + this.npcExpr.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.npcExpr = exprs[0];
        return true;
    }

    static {
        Skript.registerEffect(EffDeleteCitizen.class, (String[])new String[]{"delete (citizen|npc)[s] %npcs%"});
    }
}

