/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCClickEvent;
import net.citizensnpcs.api.event.NPCCreateEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.jetbrains.annotations.Nullable;

public class CitizenEvents
extends SimpleEvent {
    static {
        Skript.registerEvent((String)"Citizen Click", CitizenEvents.class, NPCClickEvent.class, (String[])new String[]{"(citizen|npc) click"}).description(new String[]{"Called when a Citizens NPC is clicked by a player."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen click:", "\tsend \"You clicked %event-npc%\" to event-player"});
        Skript.registerEvent((String)"Citizen Left Click", CitizenEvents.class, NPCLeftClickEvent.class, (String[])new String[]{"(citizen|npc) left click"}).description(new String[]{"Called when a Citizens NPC is left clicked by a player.", "Only is called if NPC is not vulnerable."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen left click:", "\tsend \"You left clicked %event-npc%\" to event-player"});
        Skript.registerEvent((String)"Citizen Right Click", CitizenEvents.class, NPCRightClickEvent.class, (String[])new String[]{"(citizen|npc) right click"}).description(new String[]{"Called when a Citizens NPC is right clicked by a player"}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen right click:", "\tsend \"You right clicked %event-npc%\" to event-player"});
        Skript.registerEvent((String)"Citizen Create", CitizenEvents.class, NPCCreateEvent.class, (String[])new String[]{"(citizen|npc) create"}).description(new String[]{"Called when a Citizens NPC is created by the server or an external service (Such as this plugin)."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen create:", "\tid of event-npc is 3", "\tbroadcast \"%event-npc% was created!\""});
        Skript.registerEvent((String)"Citizen Create by Player", CitizenEvents.class, PlayerCreateNPCEvent.class, (String[])new String[]{"(citizen|npc) create by [a] player"}).description(new String[]{"Called when a Citizens NPC is created by a player."}).since("1.1").requiredPlugins(new String[]{"Citizens"});
        Skript.registerEvent((String)"Citizen Create by CommandSender", CitizenEvents.class, CommandSenderCreateNPCEvent.class, (String[])new String[]{"(citizen|npc) create by [a] command [sender]"}).description(new String[]{"Called when a Citizens NPC is created via a command."}).since("1.1").requiredPlugins(new String[]{"Citizens"});
        Skript.registerEvent((String)"Citizen Spawn", CitizenEvents.class, NPCSpawnEvent.class, (String[])new String[]{"(citizen|npc) spawn"}).description(new String[]{"Called when a Citizens NPC is spawned."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen spawn:", "\tcancel event", "\tbroadcast \"You can't spawn a citizen at %event-location%\""});
        Skript.registerEvent((String)"Citizen Despawn", CitizenEvents.class, NPCDespawnEvent.class, (String[])new String[]{"(citizen|npc) despawn"}).description(new String[]{"Called when a Citizens NPC despawns."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen despawn:", "\tevent-npc is npc with id 3", "\tcancel event"});
        Skript.registerEvent((String)"Citizen Remove", CitizenEvents.class, NPCRemoveEvent.class, (String[])new String[]{"(citizen|npc) (delete|remove)"}).description(new String[]{"Called when a Citizens NPC is removed."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen remove:", "\tbroadcast \"%event-npc% was removed\""});
        Skript.registerEvent((String)"Citizen Death", CitizenEvents.class, NPCDeathEvent.class, (String[])new String[]{"(citizen|npc) death"}).description(new String[]{"Called when a Citizens NPC dies."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen death:", "\tbroadcast \"%event-npc% died due to %event-damagecause%\""});
        Skript.registerEvent((String)"Citizen Damage", CitizenEvents.class, NPCDamageEvent.class, (String[])new String[]{"(citizen|npc) damage"}).description(new String[]{"Called when a Citizens NPC is damaged", "Does not include damage by entity or damage by block, use their respective events for that."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen damage:", "\tbroadcast \"%event-npc% took %event-number% damage due to %event-damagecause%\""});
        Skript.registerEvent((String)"Citizen Damage by Entity", CitizenEvents.class, NPCDamageByEntityEvent.class, (String[])new String[]{"(citizen|npc) damage by [an] entity"}).description(new String[]{"Called when a Citizens NPC is damaged by an entity."}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen damage by an entity:", "\tbroadcast \"%event-npc% took %event-number% damage by %event-entity%\""});
        Skript.registerEvent((String)"Citizen Damage by Block", CitizenEvents.class, NPCDamageByBlockEvent.class, (String[])new String[]{"(citizen|npc) damage by [a] block"}).description(new String[]{"Called when a Citizens NPC is damaged by a block.", "Example: Lava, Fire"}).since("1.1").requiredPlugins(new String[]{"Citizens"}).examples(new String[]{"on citizen damage by block:", "\tbroadcast \"%event-npc% took %event-number% damage by %event-block\""});
        EventValues.registerEventValue(NPCEvent.class, NPC.class, (Getter)new Getter<NPC, NPCEvent>(){

            @Nullable
            public NPC get(NPCEvent event) {
                return event.getNPC();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCClickEvent.class, Player.class, (Getter)new Getter<Player, NPCClickEvent>(){

            @Nullable
            public Player get(NPCClickEvent event) {
                return event.getClicker();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerCreateNPCEvent.class, Player.class, (Getter)new Getter<Player, PlayerCreateNPCEvent>(){

            @Nullable
            public Player get(PlayerCreateNPCEvent event) {
                return event.getCreator();
            }
        }, (int)0);
        EventValues.registerEventValue(CommandSenderCreateNPCEvent.class, CommandSender.class, (Getter)new Getter<CommandSender, CommandSenderCreateNPCEvent>(){

            @Nullable
            public CommandSender get(CommandSenderCreateNPCEvent event) {
                return event.getCreator();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCSpawnEvent.class, Location.class, (Getter)new Getter<Location, NPCSpawnEvent>(){

            @Nullable
            public Location get(NPCSpawnEvent event) {
                return event.getLocation();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCSpawnEvent.class, SpawnReason.class, (Getter)new Getter<SpawnReason, NPCSpawnEvent>(){

            @Nullable
            public SpawnReason get(NPCSpawnEvent event) {
                return event.getReason();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDespawnEvent.class, DespawnReason.class, (Getter)new Getter<DespawnReason, NPCDespawnEvent>(){

            @Nullable
            public DespawnReason get(NPCDespawnEvent event) {
                return event.getReason();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDeathEvent.class, Player.class, (Getter)new Getter<Player, NPCDeathEvent>(){

            @Nullable
            public Player get(NPCDeathEvent event) {
                return event.getEvent().getEntity().getKiller();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDeathEvent.class, EntityDamageEvent.DamageCause.class, (Getter)new Getter<EntityDamageEvent.DamageCause, NPCDeathEvent>(){

            @Nullable
            public EntityDamageEvent.DamageCause get(NPCDeathEvent event) {
                EntityDeathEvent devent = event.getEvent();
                return devent.getEntity().getLastDamageCause().getCause();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDamageEvent.class, EntityDamageEvent.DamageCause.class, (Getter)new Getter<EntityDamageEvent.DamageCause, NPCDamageEvent>(){

            @Nullable
            public EntityDamageEvent.DamageCause get(NPCDamageEvent event) {
                return event.getCause();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDamageEvent.class, Double.class, (Getter)new Getter<Double, NPCDamageEvent>(){

            @Nullable
            public Double get(NPCDamageEvent event) {
                return event.getDamage();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDamageByEntityEvent.class, Entity.class, (Getter)new Getter<Entity, NPCDamageByEntityEvent>(){

            @Nullable
            public Entity get(NPCDamageByEntityEvent event) {
                return event.getDamager();
            }
        }, (int)0);
        EventValues.registerEventValue(NPCDamageByBlockEvent.class, Block.class, (Getter)new Getter<Block, NPCDamageByBlockEvent>(){

            @Nullable
            public Block get(NPCDamageByBlockEvent event) {
                return event.getDamager();
            }
        }, (int)0);
    }
}

