/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Activation Range")
@Description(value={"The activation range of a citizen."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.2.3-b1"})
@Examples(value={"set npc activation range of {_npc} to 7"})
public class ExprActivationRange
extends SimplePropertyExpression<NPC, Number> {
    @Nullable
    public Number convert(NPC npc) {
        return (Number)npc.data().get(NPC.Metadata.ACTIVATION_RANGE);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof Number) {
            Number range = (Number)delta[0];
            NPC[] nPCArray = (NPC[])this.getExpr().getArray(event);
            int n = nPCArray.length;
            for (int i = 0; i < n; ++i) {
                NPC npc = nPCArray[i];
                npc.data().setPersistent(NPC.Metadata.ACTIVATION_RANGE, (Object)range);
            }
        }
        if (delta == null) {
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                npc.data().remove(NPC.Metadata.ACTIVATION_RANGE);
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen activation range";
    }

    static {
        ExprActivationRange.register(ExprActivationRange.class, Number.class, (String)"(citizen|npc) activation range", (String)"npcs");
    }
}

