/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="All Citizens")
@Description(value={"Expression of all citizens."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.7"})
@Examples(value={"broadcast all citizens", "loop all citizens:", "\tbroadcast id of loop-value"})
public class ExprAllCitizens
extends SimpleExpression<NPC> {
    @Nullable
    protected NPC[] get(Event event) {
        NPCRegistry registry = CitizensAPI.getNPCRegistry();
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        for (NPC npc : registry.sorted()) {
            npcs.add(npc);
        }
        return npcs.toArray(new NPC[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends NPC> getReturnType() {
        return NPC.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "all citizens";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        return true;
    }

    static {
        Skript.registerExpression(ExprAllCitizens.class, NPC.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all (citizens|npcs)"});
    }
}

