/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Entity Type")
@Description(value={"Get the entity type of a citizen", "For most entitytypes, you have to put 'minecraft:' in front of it for it to work."})
@RequiredPlugins(value={"Citizens"})
@Since(value={"1.0.4, 1.0.5 (setting)"})
@Examples(value={"set citizen entity type of last spawned entity to villager"})
public class ExprCitizenEntityType
extends SimplePropertyExpression<NPC, EntityType> {
    @Nullable
    public EntityType convert(NPC npc) {
        return npc.getEntity().getType();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{EntityType.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof EntityType) {
            EntityType type = (EntityType)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                npc.setBukkitEntityType(type);
            }
        }
    }

    @NotNull
    public Class<? extends EntityType> getReturnType() {
        return EntityType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen entity type";
    }

    static {
        ExprCitizenEntityType.register(ExprCitizenEntityType.class, EntityType.class, (String)"(citizen|npc) entity type", (String)"npcs");
    }
}

