/*
 * Decompiled with CFR 0.152.
 */
package au.nagasonic.skonic.elements.citizens.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Citizen Gamemode")
@Description(value={"The gamemode of a Citizens NPC. Only applicable if the Citizen's entity type is a Player."})
@Since(value={"1.2.2-b1"})
@Examples(value={"set gamemode of npc with id 3 to creative"})
@RequiredPlugins(value={"Citizens"})
public class ExprCitizenGamemode
extends SimplePropertyExpression<NPC, GameMode> {
    @Nullable
    public GameMode convert(NPC npc) {
        return ((Player)npc.getEntity()).getGameMode();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{GameMode.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null && delta[0] instanceof GameMode) {
            GameMode gamemode = (GameMode)delta[0];
            for (NPC npc : (NPC[])this.getExpr().getArray(event)) {
                if (!(npc.getEntity() instanceof Player)) continue;
                Player npcPlayer = (Player)npc.getEntity();
                npcPlayer.setGameMode(gamemode);
            }
        }
    }

    @NotNull
    public Class<? extends GameMode> getReturnType() {
        return GameMode.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "citizen gamemode";
    }

    static {
        ExprCitizenGamemode.register(ExprCitizenGamemode.class, GameMode.class, (String)"(citizen|npc) game[ ]mode", (String)"npcs");
    }
}

